/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.unzip.file;

import nuxeo.unzip.file.UnzipToDocuments;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Document.UnzipFileToDocuments", category="Document", label="Unzip and create documents", description="Unzip file and create the same structure in the target (the current folder if target isn't provided). When using a blob as input, the target parameter is required. The operation does nothing if the input is null. every commitModulo documents created, the transaction is commited.")
public class UnzipFileFoDocumentsOp {
    public static final String ID = "Document.UnzipFileToDocuments";
    @Context
    protected CoreSession session;
    @Param(name="target", required=false)
    protected DocumentModel target;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath;
    @Param(name="folderishType", required=false, values={"Folder"})
    protected String folderishType;
    @Param(name="commitModulo", required=false, values={"100"})
    protected Integer commitModulo;

    @OperationMethod
    public DocumentModel run(DocumentModel input) {
        if (input == null) {
            return input;
        }
        DocumentRef parent = input.getParentRef();
        DocumentModel parentDocument = this.target == null ? this.session.getDocument(parent) : this.target;
        if (StringUtils.isBlank((CharSequence)this.xpath)) {
            this.xpath = "file:content";
        }
        Blob zipBlob = (Blob)input.getPropertyValue(this.xpath);
        UnzipToDocuments.run(parentDocument, zipBlob, this.folderishType, this.commitModulo == null ? 0 : this.commitModulo);
        return input;
    }

    @OperationMethod
    public Blob run(Blob input) {
        if (input == null) {
            return input;
        }
        if (this.target == null) {
            throw new IllegalArgumentException("When receiving a Blob, the target parameter cannot be empty");
        }
        UnzipToDocuments.run(this.target, input, this.folderishType, this.commitModulo);
        return input;
    }
}

