/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.unzip.file;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import nuxeo.unzip.file.UnzipToDocuments;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;

public class UnzipFileToDocumentsImporter
extends AbstractFileImporter {
    private static final long serialVersionUID = -1018545014286064763L;
    protected static Log log = LogFactory.getLog(UnzipFileToDocumentsImporter.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean looksLikeValidZip(File file) {
        try (ZipFile zip = new ZipFile(file);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public DocumentModel createOrUpdate(FileImporterContext context) {
        DocumentModel mainFolderDoc = null;
        try (CloseableFile source = context.getBlob().getCloseableFile();){
            if (UnzipFileToDocumentsImporter.looksLikeValidZip(source.getFile())) {
                DocumentModel parent = context.getSession().getDocument((DocumentRef)new PathRef(context.getParentPath()));
                mainFolderDoc = UnzipToDocuments.run(parent, context.getBlob(), null, 0);
            }
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        return mainFolderDoc;
    }
}

