/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.unzip.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class UnzipToDocuments {
    protected static Log logger = LogFactory.getLog(UnzipToDocuments.class);
    public static String DEFAULT_FOLDERISH_TYPE = "Folder";
    public static int DEFAULT_COMMIT_MODULO = 100;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DocumentModel run(DocumentModel parentDocument, Blob zipBlob, String folderishType, int commitModulo) throws NuxeoException {
        String tmpDir = Environment.getDefault().getTemp().getPath();
        Path tmpDirPath = tmpDir != null ? Paths.get(tmpDir, new String[0]) : null;
        Path outDirPath = null;
        File mainParentFolderOnDisk = null;
        DocumentModel mainUnzippedFolderDoc = null;
        boolean isMainUzippedFolderDoc = false;
        CoreSession session = parentDocument.getCoreSession();
        FileManager fileManager = (FileManager)Framework.getService(FileManager.class);
        if (StringUtils.isBlank((CharSequence)folderishType)) {
            folderishType = DEFAULT_FOLDERISH_TYPE;
        }
        if (commitModulo <= 0) {
            commitModulo = DEFAULT_COMMIT_MODULO;
        }
        try {
            outDirPath = tmpDirPath != null ? Files.createTempDirectory(tmpDirPath, "NxUnzip", new FileAttribute[0]) : Framework.createTempDirectory(null, (FileAttribute[])new FileAttribute[0]);
            byte[] buffer = new byte[4096];
            int len = 0;
            int count = 0;
            File folder = new File(outDirPath.toString());
            if (!folder.exists()) {
                folder.mkdir();
            }
            mainParentFolderOnDisk = folder;
            File zipBlobFile = zipBlob.getFile();
            ZipFile zipFile = new ZipFile(zipBlobFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            TreeMap<String, ZipEntry> entriesByName = new TreeMap<String, ZipEntry>();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                entriesByName.put(entry.getName(), entry);
            }
            for (ZipEntry entry : entriesByName.values()) {
                File newFile;
                String path;
                String fileName = entry.getName();
                if (fileName.startsWith("__MACOSX/") || fileName.startsWith(".") || fileName.contentEquals("../") || fileName.endsWith(".DS_Store")) continue;
                String dcTitle = fileName.split("/")[fileName.split("/").length - 1];
                int idx = fileName.lastIndexOf("/");
                String string = path = idx == -1 ? "" : fileName.substring(0, idx);
                if (entry.isDirectory()) {
                    if (path.indexOf("/") == -1) {
                        isMainUzippedFolderDoc = true;
                        path = "";
                    } else {
                        path = path.substring(0, path.lastIndexOf("/"));
                    }
                    newFile = new File(outDirPath.toString() + File.separator + fileName);
                    newFile.mkdirs();
                    DocumentModel docFolder = session.createDocumentModel(parentDocument.getPathAsString() + "/" + path, dcTitle, folderishType);
                    docFolder.setProperty("dublincore", "title", (Object)dcTitle);
                    docFolder = session.createDocument(docFolder);
                    session.saveDocument(docFolder);
                    if (!isMainUzippedFolderDoc || mainUnzippedFolderDoc != null) continue;
                    mainUnzippedFolderDoc = docFolder;
                    isMainUzippedFolderDoc = false;
                    continue;
                }
                newFile = new File(outDirPath.toString() + File.separator + fileName);
                FileOutputStream fos = new FileOutputStream(newFile);
                InputStream zipEntryStream = zipFile.getInputStream(entry);
                while ((len = zipEntryStream.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                FileBlob blob = new FileBlob(newFile);
                FileImporterContext context = FileImporterContext.builder((CoreSession)session, (Blob)blob, (String)(parentDocument.getPathAsString() + "/" + path)).overwrite(true).fileName(blob.getFilename()).build();
                fileManager.createOrUpdateDocument(context);
                if (++count % commitModulo != 0) continue;
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
            }
            zipFile.close();
            if (mainParentFolderOnDisk == null) return mainUnzippedFolderDoc;
        }
        catch (IOException e) {
            try {
                throw new NuxeoException("Error while unzipping and creating Documents", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (mainParentFolderOnDisk == null) throw throwable;
                FileUtils.deleteQuietly(mainParentFolderOnDisk);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)mainParentFolderOnDisk);
        return mainUnzippedFolderDoc;
    }
}

