/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.vertesia.automation.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.labs.vertesia.automation.execution.RunRequest;
import org.nuxeo.labs.vertesia.automation.service.VertesiaService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class VertesiaComponent
extends DefaultComponent
implements VertesiaService {
    private static final Logger log = LogManager.getLogger(VertesiaComponent.class);
    public static final MediaType JSON = MediaType.get((String)"application/json");
    public static final String BASE_URL = "vertesia.api.url";
    public static final String API_KEY = "vertesia.api.key";
    public static final String TIMEOUT = "vertesia.http.timeout";
    protected OkHttpClient client;
    protected static final ObjectMapper objectMapper = new ObjectMapper();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String runExecution(RunRequest runRequest) {
        RequestBody body;
        try {
            String json = objectMapper.writeValueAsString((Object)runRequest);
            log.debug(json);
            body = RequestBody.create((String)json, (MediaType)JSON);
        }
        catch (JsonProcessingException e) {
            throw new NuxeoException((Throwable)e);
        }
        Request request = new Request.Builder().header("Accept", "application/json").header("Authorization", String.format("Bearer %s", Framework.getProperty((String)API_KEY))).url(String.format("%s/runs", Framework.getProperty((String)BASE_URL))).post(body).build();
        try (Response response = this.getClient().newCall(request).execute();){
            if (!response.isSuccessful()) throw new NuxeoException(response.body().string());
            String string = response.body().string();
            return string;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OkHttpClient getClient() {
        OkHttpClient result = this.client;
        if (result == null) {
            VertesiaComponent vertesiaComponent = this;
            synchronized (vertesiaComponent) {
                result = this.client;
                if (result == null) {
                    long timeout = Long.parseLong(Framework.getProperty((String)TIMEOUT, (String)"60"));
                    this.client = result = new OkHttpClient.Builder().readTimeout(timeout, TimeUnit.SECONDS).build();
                }
            }
        }
        return result;
    }
}

