/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.ext.work;

import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.VideoHelper;
import org.nuxeo.ecm.platform.video.service.VideoInfoWork;
import org.nuxeo.labs.video.ext.service.VideoInfoService;
import org.nuxeo.runtime.api.Framework;

public class ExtendedVideoInfoWork
extends VideoInfoWork {
    public static final String VIDEO_INFO_DONE_EVENT = "videoInfoDone";
    private static final Logger log = LogManager.getLogger(ExtendedVideoInfoWork.class);

    public ExtendedVideoInfoWork(String repositoryName, String docId) {
        super(repositoryName, docId);
    }

    public void work() {
        this.setStatus("Updating video info");
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        VideoHelper.newTransaction();
        this.openSystemSession();
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        this.updateVideoInfo(doc);
        this.fireVideoInfoDoneEvent(doc);
        this.setStatus("Done");
    }

    protected void fireVideoInfoDoneEvent(DocumentModel doc) {
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        Event event = ctx.newEvent(VIDEO_INFO_DONE_EVENT);
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
    }

    protected void updateVideoInfo(DocumentModel doc) {
        VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
        if (videoDocument.getVideo().getWidth() != 0L && videoDocument.getVideo().getHeight() != 0L) {
            return;
        }
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        Blob video = blobHolder.getBlob();
        log.debug(String.format("Updating video info of document %s.", doc));
        VideoInfoService videoInfoService = (VideoInfoService)Framework.getService(VideoInfoService.class);
        videoInfoService.updateVideoInfo(doc, video);
        log.debug(String.format("End updating video info of document %s.", doc));
        if (doc.isVersion()) {
            doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        this.session.saveDocument(doc);
    }
}

