/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.ext.service;

import java.io.IOException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.video.VideoHelper;
import org.nuxeo.labs.video.ext.adapter.StoryboardAdapter;
import org.nuxeo.labs.video.ext.api.Frame;
import org.nuxeo.labs.video.ext.service.VideoStoryBoardService;
import org.nuxeo.labs.video.ext.work.ExtendedVideoStoryboardWork;
import org.nuxeo.runtime.api.Framework;

public class VideoStoryBoardServiceImpl
implements VideoStoryBoardService {
    private static final Logger log = LogManager.getLogger(VideoStoryBoardServiceImpl.class);
    public static final String SCREENSHOT_CONVERTER_NAME = "video-screenshot";

    @Override
    public void updateStoryboard(DocumentModel docModel, Blob video) {
        this.updateStoryboard(docModel, video, new long[0]);
    }

    @Override
    public void updateStoryboard(DocumentModel docModel, Blob video, long[] timecodes) {
        if (timecodes.length < 1) {
            VideoHelper.updateStoryboard((DocumentModel)docModel, (Blob)video);
        } else {
            this.computeStoryBoard(docModel, video, timecodes);
        }
    }

    @Override
    public void clearStoryboard(DocumentModel docModel) {
        VideoHelper.updateStoryboard((DocumentModel)docModel, null);
    }

    @Override
    public void updatePreviews(DocumentModel docModel, Blob video) throws IOException {
        VideoHelper.updatePreviews((DocumentModel)docModel, (Blob)video);
    }

    @Override
    public void clearPreviews(DocumentModel docModel) throws IOException {
        VideoHelper.updatePreviews((DocumentModel)docModel, null);
    }

    @Override
    public void scheduleVideoStoryboardWork(DocumentModel doc) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        ExtendedVideoStoryboardWork work = new ExtendedVideoStoryboardWork(doc.getRepositoryName(), doc.getId());
        log.debug("Scheduling work: video storyboard of document {}.", (Object)doc);
        workManager.schedule((Work)work, true);
    }

    public void computeStoryBoard(DocumentModel docModel, Blob video, long[] timecodes) {
        StoryboardAdapter storyboard = (StoryboardAdapter)docModel.getAdapter(StoryboardAdapter.class);
        for (long timecode : timecodes) {
            try {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("position", String.format("%dms", timecode));
                BlobHolder result = ((ConversionService)Framework.getService(ConversionService.class)).convert(SCREENSHOT_CONVERTER_NAME, (BlobHolder)new SimpleBlobHolder(video), parameters);
                Frame frame = new Frame(result.getBlob(), (double)timecode * 1.0, null);
                storyboard.addFrame(frame);
            }
            catch (ConversionException e) {
                log.warn(String.format("could not extract story board for document '%s' with video file '%s': %s", docModel.getTitle(), video, e.getMessage()));
                log.debug((Object)e, (Throwable)e);
                return;
            }
        }
    }
}

