/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.ext.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.map.HashedMap;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.labs.video.ext.api.Frame;
import org.nuxeo.labs.video.ext.api.Storyboard;

public class StoryboardAdapter
implements Storyboard {
    private final DocumentModel doc;
    private final SortedSet<Frame> frames = new TreeSet<Frame>(Comparator.comparingDouble(Frame::getTimeInSeconds));

    public StoryboardAdapter(DocumentModel doc) {
        this.doc = doc;
        List property = (List)((Object)doc.getPropertyValue("vid:storyboard"));
        if (property != null) {
            for (Map item : property) {
                Frame frame = new Frame();
                frame.setBlob((Blob)item.get("content"));
                frame.setTimeInSeconds((Double)item.get("timecode"));
                frame.setComment((String)item.get("comment"));
                this.frames.add(frame);
            }
        }
    }

    @Override
    public void addFrame(Frame frame) {
        this.frames.add(frame);
        this.updateDoc();
    }

    @Override
    public void addAllFrames(List<Frame> frames) {
        this.frames.addAll(frames);
        this.updateDoc();
    }

    @Override
    public int size() {
        return this.frames.size();
    }

    @Override
    public List<Frame> getFrames() {
        return new ArrayList<Frame>(this.frames);
    }

    protected void updateDoc() {
        ArrayList<HashedMap> property = new ArrayList<HashedMap>();
        for (Frame frame : this.frames) {
            HashedMap item = new HashedMap();
            item.put("content", (Serializable)frame.getBlob());
            item.put("timecode", frame.getTimeInSeconds());
            item.put("comment", frame.getComment());
            property.add(item);
        }
        this.doc.setPropertyValue("vid:storyboard", (Serializable)property);
    }
}

