/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.ext.automation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.labs.video.ext.service.VideoStoryBoardService;

@Operation(id="Video.Storyboard", category="Video", label="Generate a storyboard", description="Generate a storyboard for the input video document")
public class VideoStoryboardOp {
    public static final String ID = "Video.Storyboard";
    private static final Log log = LogFactory.getLog(VideoStoryboardOp.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected VideoStoryBoardService storyboardService;
    @Param(name="timecodeListInSeconds", description="List of timecodes in seconds", required=false)
    protected List<String> timecodeListInSeconds = new ArrayList<String>();
    @Param(name="save", description="Save modification made to the input document", required=false)
    protected boolean save = false;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        VideoDocument videoDoc = (VideoDocument)doc.getAdapter(VideoDocument.class);
        if (videoDoc == null) {
            return doc;
        }
        if (!this.timecodeListInSeconds.isEmpty()) {
            double[] timecodes = this.timecodeListInSeconds.stream().mapToDouble(Double::parseDouble).toArray();
            this.storyboardService.updateStoryboard(doc, timecodes);
        } else {
            this.storyboardService.updateStoryboard(doc);
        }
        this.storyboardService.updatePreviews(doc);
        if (this.save) {
            doc = this.ctx.getCoreSession().saveDocument(doc);
        }
        return doc;
    }
}

