/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.ext.listener;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.listener.VideoChangedListener;
import org.nuxeo.labs.video.ext.service.VideoInfoService;
import org.nuxeo.labs.video.ext.service.VideoStoryBoardService;
import org.nuxeo.runtime.api.Framework;

public class ExtendedVideoChangedListener
extends VideoChangedListener {
    private static final Logger log = LogManager.getLogger(ExtendedVideoChangedListener.class);

    protected void resetProperties(DocumentModel doc) {
        log.debug("Resetting video info, storyboard, previews and conversions of document {}", (Object)doc);
        VideoInfoService videoInfoService = (VideoInfoService)Framework.getService(VideoInfoService.class);
        videoInfoService.clearVideoInfo(doc);
        VideoStoryBoardService videoStoryBoardService = (VideoStoryBoardService)Framework.getService(VideoStoryBoardService.class);
        videoStoryBoardService.clearStoryboard(doc);
        videoStoryBoardService.clearPreviews(doc);
        doc.setPropertyValue("vid:transcodedVideos", null);
    }

    protected void scheduleAsyncProcessing(DocumentModel doc) {
        VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
        if (videoDocument.getVideo().getBlob() != null) {
            VideoInfoService videoInfoService = (VideoInfoService)Framework.getService(VideoInfoService.class);
            videoInfoService.scheduleVideoInfoWork(doc);
        } else {
            log.debug("Document doesn't hold a video file, skipping video info, storyboard and conversions of document {}", (Object)doc);
        }
    }
}

