/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.ext.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.math3.util.Precision;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.VideoHelper;
import org.nuxeo.labs.video.ext.adapter.StoryboardAdapter;
import org.nuxeo.labs.video.ext.api.Frame;
import org.nuxeo.labs.video.ext.service.VideoStoryBoardService;
import org.nuxeo.labs.video.ext.work.ExtendedVideoStoryboardWork;
import org.nuxeo.runtime.api.Framework;

public class VideoStoryBoardServiceImpl
implements VideoStoryBoardService {
    public static final String SCREENSHOT_CONVERTER_NAME = "video-screenshot";
    private static final Logger log = LogManager.getLogger(VideoStoryBoardServiceImpl.class);

    @Override
    public void updateStoryboard(DocumentModel docModel) {
        this.updateStoryboard(docModel, new double[0]);
    }

    @Override
    public void updateStoryboard(DocumentModel docModel, double[] timecodeInSeconds) {
        VideoDocument videoDocument = (VideoDocument)docModel.getAdapter(VideoDocument.class);
        if (timecodeInSeconds.length < 1) {
            VideoHelper.updateStoryboard((DocumentModel)docModel, (Blob)videoDocument.getVideo().getBlob());
        } else {
            this.computeStoryBoard(docModel, timecodeInSeconds);
        }
    }

    @Override
    public void clearStoryboard(DocumentModel docModel) {
        VideoHelper.updateStoryboard((DocumentModel)docModel, null);
    }

    @Override
    public void updatePreviews(DocumentModel docModel) {
        VideoDocument videoDocument = (VideoDocument)docModel.getAdapter(VideoDocument.class);
        try {
            VideoHelper.updatePreviews((DocumentModel)docModel, (Blob)videoDocument.getVideo().getBlob());
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void updatePreviews(DocumentModel docModel, double timecodeInSecond) {
        VideoDocument videoDocument = (VideoDocument)docModel.getAdapter(VideoDocument.class);
        double roundedTimecode = Precision.round((double)timecodeInSecond, (int)3);
        try {
            ArrayList views = new ArrayList();
            LinkedHashMap<String, Object> thumbnailView = new LinkedHashMap<String, Object>();
            thumbnailView.put("title", "Small");
            thumbnailView.put("maxsize", 350L);
            views.add(thumbnailView);
            HashMap<String, Object> staticPlayerView = new HashMap<String, Object>();
            staticPlayerView.put("title", "StaticPlayerView");
            staticPlayerView.put("maxsize", 1200L);
            views.add(staticPlayerView);
            VideoHelper.updatePreviews((DocumentModel)docModel, (Blob)videoDocument.getVideo().getBlob(), (Double)roundedTimecode, views);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void clearPreviews(DocumentModel docModel) {
        try {
            VideoHelper.updatePreviews((DocumentModel)docModel, null);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void scheduleVideoStoryboardWork(DocumentModel doc) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        ExtendedVideoStoryboardWork work = new ExtendedVideoStoryboardWork(doc.getRepositoryName(), doc.getId());
        log.debug("Scheduling work: video storyboard of document {}.", (Object)doc);
        workManager.schedule((Work)work, true);
    }

    public void computeStoryBoard(DocumentModel docModel, double[] timecodesInSeconds) {
        StoryboardAdapter storyboard = (StoryboardAdapter)docModel.getAdapter(StoryboardAdapter.class);
        VideoDocument videoDocument = (VideoDocument)docModel.getAdapter(VideoDocument.class);
        Blob video = videoDocument.getVideo().getBlob();
        for (double timecode : timecodesInSeconds) {
            try {
                double roundedTimecode = Precision.round((double)timecode, (int)3);
                Blob screenshot = this.screenshot(video, roundedTimecode);
                Frame frame = new Frame(screenshot, roundedTimecode, null);
                storyboard.addFrame(frame);
            }
            catch (ConversionException e) {
                log.error(String.format("could not extract story board for document '%s' with video file '%s': %s", docModel.getTitle(), video, e.getMessage()));
            }
        }
    }

    @Override
    public Blob screenshot(Blob video, double timecode) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("position", String.format("%.3f", timecode));
        BlobHolder result = ((ConversionService)Framework.getService(ConversionService.class)).convert(SCREENSHOT_CONVERTER_NAME, (BlobHolder)new SimpleBlobHolder(video), parameters);
        return result.getBlob();
    }
}

