/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.ext.work;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.video.service.VideoStoryboardWork;
import org.nuxeo.labs.video.ext.service.VideoStoryBoardService;
import org.nuxeo.runtime.api.Framework;

public class ExtendedVideoStoryboardWork
extends VideoStoryboardWork {
    public static final String VIDEO_STORYBOARD_DONE_EVENT = "videoStoryboardDone";
    private static final Logger log = LogManager.getLogger(ExtendedVideoStoryboardWork.class);

    public ExtendedVideoStoryboardWork(String repositoryName, String docId) {
        super(repositoryName, docId);
    }

    public void work() {
        super.work();
        this.fireVideoStoryboardDoneEvent();
    }

    protected boolean updateStoryboard(DocumentModel doc, Blob blob) {
        List storyboard = (List)((Object)doc.getPropertyValue("vid:storyboard"));
        if (storyboard != null && !storyboard.isEmpty()) {
            return false;
        }
        log.debug(String.format("Updating storyboard of Video document %s.", doc));
        VideoStoryBoardService videoStoryBoardService = (VideoStoryBoardService)Framework.getService(VideoStoryBoardService.class);
        videoStoryBoardService.updateStoryboard(doc);
        log.debug(String.format("End updating storyboard of Video document %s.", doc));
        return true;
    }

    protected boolean updatePreviews(DocumentModel doc, Blob blob) {
        List previews = (List)((Object)doc.getPropertyValue("picture:views"));
        if (previews != null && !previews.isEmpty()) {
            return false;
        }
        log.debug(String.format("Updating previews of Video document %s.", doc));
        VideoStoryBoardService videoStoryBoardService = (VideoStoryBoardService)Framework.getService(VideoStoryBoardService.class);
        videoStoryBoardService.updatePreviews(doc);
        log.debug(String.format("End updating previews of Video document %s.", doc));
        return true;
    }

    protected void fireVideoStoryboardDoneEvent() {
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        Event event = ctx.newEvent(VIDEO_STORYBOARD_DONE_EVENT);
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
    }
}

