/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.ext.listener;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.video.service.AutomaticVideoConversion;
import org.nuxeo.ecm.platform.video.service.AutomaticVideoConversionGetter;
import org.nuxeo.runtime.api.Framework;

public class TriggerVideoConversionListener
implements EventListener {
    public static final String VIDEOS_QUERY = "SELECT * FROM Document WHERE ecm:uuid = '%s'";

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        List conversions = AutomaticVideoConversionGetter.getAutomaticVideoConversions().stream().map(AutomaticVideoConversion::getName).collect(Collectors.toList());
        if (!conversions.isEmpty()) {
            BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
            bulkService.submit(new BulkCommand.Builder("recomputeVideoConversion", String.format(VIDEOS_QUERY, doc.getId()), "system").repository(ctx.getCoreSession().getRepositoryName()).param("xpath", (Serializable)((Object)"file:content")).param("onlyRecomputeMissingVideoInfo", (Serializable)Boolean.valueOf(false)).param("conversionNames", (Serializable)((Object)conversions)).build());
        }
    }
}

