/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.ext.automation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.labs.video.ext.service.VideoStoryBoardService;

@Operation(id="Video.Preview", category="Video", label="Generate a preview and thumbnail", description="Generate a preview and thumbnail image for the input video document")
public class VideoPreviewOp {
    public static final String ID = "Video.Preview";
    private static final Logger log = LogManager.getLogger(VideoPreviewOp.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected VideoStoryBoardService storyboardService;
    @Param(name="timecodeInSecond", description="Timecode in second", required=false)
    protected Double timecodeInSecond;
    @Param(name="save", description="Save modification made to the input document", required=false)
    protected boolean save = false;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        VideoDocument videoDoc = (VideoDocument)doc.getAdapter(VideoDocument.class, true);
        if (videoDoc == null) {
            return doc;
        }
        if (this.timecodeInSecond == null) {
            this.storyboardService.updatePreviews(doc);
        } else {
            this.storyboardService.updatePreviews(doc, this.timecodeInSecond);
        }
        if (this.save) {
            doc = this.ctx.getCoreSession().saveDocument(doc);
        }
        return doc;
    }
}

