/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.ext.converter;

import java.io.Serializable;
import java.util.Map;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.video.VideoInfo;
import org.nuxeo.ecm.platform.video.convert.VideoConversionConverter;

public class ExtendedVideoConverter
extends VideoConversionConverter {
    protected Map<String, String> getCmdStringParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) {
        Map cmdStringParams = super.getCmdStringParameters(blobHolder, parameters);
        this.setVideoTargetDimensions(cmdStringParams, parameters);
        return cmdStringParams;
    }

    public void setVideoTargetDimensions(Map<String, String> cmdStringParams, Map<String, Serializable> parameters) {
        long newWidth;
        long newHeight;
        VideoInfo videoInfo = (VideoInfo)parameters.get("videoInfo");
        if (videoInfo == null) {
            return;
        }
        long width = videoInfo.getWidth();
        long height = videoInfo.getHeight();
        long shortSideDimension = (Long)parameters.get("height");
        shortSideDimension += shortSideDimension % 2L;
        if (width >= height) {
            newHeight = shortSideDimension;
            newWidth = ExtendedVideoConverter.crossMultiply(width, height, newHeight);
        } else {
            newWidth = shortSideDimension;
            newHeight = ExtendedVideoConverter.crossMultiply(height, width, newWidth);
        }
        cmdStringParams.put("width", String.valueOf(newWidth));
        cmdStringParams.put("height", String.valueOf(newHeight));
    }

    public static long crossMultiply(long value, long otherDimensionValue, long otherDimensionNewValue) {
        long result = otherDimensionNewValue * value / otherDimensionValue;
        result += result % 2L;
        return result;
    }
}

