/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.ext.automation;

import java.io.Serializable;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.VideoHelper;
import org.nuxeo.ecm.platform.video.VideoInfo;

@Operation(id="Video.AddConversion", category="Video", label="Add a stored conversion", description="Add a stored conversion")
public class VideoAddConversion {
    public static final String ID = "Video.AddConversion";
    private static final Logger log = LogManager.getLogger(VideoAddConversion.class);
    @Context
    protected OperationContext ctx;
    @Context
    CoreSession session;
    @Param(name="name", required=true)
    String name;
    @Param(name="videoBlob", required=true)
    Blob videoBlob;
    @Param(name="save", required=false)
    boolean save = false;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        List transcodedVideos = (List)((Object)doc.getPropertyValue("vid:transcodedVideos"));
        transcodedVideos.removeIf(tv -> this.name.equals(tv.get("name")));
        VideoInfo videoInfo = VideoHelper.getVideoInfo((Blob)this.videoBlob);
        TranscodedVideo tv2 = TranscodedVideo.fromBlobAndInfo((String)this.name, (Blob)this.videoBlob, (VideoInfo)videoInfo);
        transcodedVideos.add(tv2.toMap());
        doc.setPropertyValue("vid:transcodedVideos", (Serializable)((Object)transcodedVideos));
        if (this.save) {
            this.session.saveDocument(doc);
        }
        return doc;
    }
}

