/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.ext.listener;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.VideoInfo;
import org.nuxeo.ecm.platform.video.service.AutomaticVideoConversion;
import org.nuxeo.ecm.platform.video.service.AutomaticVideoConversionGetter;
import org.nuxeo.runtime.api.Framework;

public class TriggerVideoConversionListener
implements EventListener {
    public static final String VIDEOS_QUERY = "SELECT * FROM Document WHERE ecm:uuid = '%s'";
    public static final String NO_DOWNSCALING_VIDEO_CONVERSION_AVAILABLE = "noDownscalingVideoConversionAvailable";

    public void handleEvent(Event event) {
        VideoDocument video;
        VideoInfo videoInfo;
        long shortDimension;
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        List<String> conversions = AutomaticVideoConversionGetter.getAutomaticVideoConversions().stream().map(AutomaticVideoConversion::getName).collect(Collectors.toList());
        if (conversions.isEmpty()) {
            return;
        }
        if ("false".equals(Framework.getProperty((String)"nuxeo.video.conversion.allow.upscaling", (String)"true")) && (conversions = AutomaticVideoConversionGetter.filerUpscalingConversion(shortDimension = Math.min((videoInfo = (video = (VideoDocument)doc.getAdapter(VideoDocument.class, true)).getVideo().getVideoInfo()).getWidth(), videoInfo.getHeight()), conversions)).isEmpty()) {
            CoreSession session = doc.getCoreSession();
            DocumentEventContext dec = new DocumentEventContext(session, session.getPrincipal(), doc);
            Event e = dec.newEvent(NO_DOWNSCALING_VIDEO_CONVERSION_AVAILABLE);
            ((EventService)Framework.getService(EventService.class)).fireEvent(e);
        }
        if (!conversions.isEmpty()) {
            BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
            bulkService.submit(new BulkCommand.Builder("recomputeVideoConversion", String.format(VIDEOS_QUERY, doc.getId()), "system").repository(ctx.getCoreSession().getRepositoryName()).param("xpath", (Serializable)((Object)"file:content")).param("onlyRecomputeMissingVideoInfo", (Serializable)Boolean.valueOf(false)).param("conversionNames", (Serializable)((Object)conversions)).build());
        }
    }
}

