/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.mediainfo.mapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.labs.video.mediainfo.mapper.VideoInfoWorker;
import org.nuxeo.runtime.api.Framework;

public class CustomVideoChangedListener
implements EventListener {
    private static final Log log = LogFactory.getLog(CustomVideoChangedListener.class);

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.hasFacet("HasVideoPreview") && !doc.isProxy() && !doc.isVersion()) {
            boolean forceGeneration = Boolean.TRUE.equals(doc.getContextData("forceInformationsGeneration"));
            Property origVideoProperty = doc.getProperty("file:content");
            if (forceGeneration || "documentCreated".equals(event.getName()) || origVideoProperty.isDirty()) {
                Blob video = (Blob)origVideoProperty.getValue();
                if ("beforeDocumentModification".equals(event.getName())) {
                    doc.setPropertyValue("vid:info", null);
                    doc.setPropertyValue("vid:transcodedVideos", null);
                    doc.setPropertyValue("vid:storyboard", null);
                    doc.setPropertyValue("picture:views", null);
                }
                if (video != null) {
                    VideoInfoWorker work = new VideoInfoWorker(doc.getRepositoryName(), doc.getId());
                    WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
                    workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
                }
            }
        }
    }
}

