/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.mediainfo.mapper;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.runtime.api.Framework;

public class MediaInfoHelper {
    public static final String MEDIAINFO_INFO_COMMAND_LINE = "mediainfo-info";

    private MediaInfoHelper() {
    }

    public static Map<String, Map<String, String>> getProcessedMediaInfo(Blob video) throws NuxeoException {
        return MediaInfoHelper.processMediaInfo(MediaInfoHelper.getRawMediaInfo(video));
    }

    public static String getSpecificMediaInfo(String key1, String key2, Blob video) throws NuxeoException {
        return MediaInfoHelper.getProcessedMediaInfo(video).get(key1).get(key2);
    }

    public static List<String> getRawMediaInfo(Blob blob) throws NuxeoException {
        String uriStr = null;
        if (blob instanceof ManagedBlob) {
            ManagedBlob managedBlob = (ManagedBlob)blob;
            BlobProvider blobProvider = ((BlobManager)Framework.getLocalService(BlobManager.class)).getBlobProvider(blob);
            try {
                URI uri = blobProvider.getURI(managedBlob, BlobManager.UsageHint.DOWNLOAD, null);
                if (uri != null) {
                    uriStr = uri.toString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (uriStr == null) {
            try {
                File file = Framework.createTempFile((String)"mediainfo", (String)("." + FilenameUtils.getExtension((String)blob.getFilename())));
                blob.transferTo(file);
                uriStr = file.getAbsolutePath();
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        try {
            CommandLineExecutorService cleService = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
            CmdParameters params = new CmdParameters();
            params.addNamedParameter("url", uriStr);
            return cleService.execCommand(MEDIAINFO_INFO_COMMAND_LINE, params).getOutput();
        }
        catch (CommandNotAvailable e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public static Map<String, Map<String, String>> processMediaInfo(List<String> input) {
        HashMap<String, Map<String, String>> output = new HashMap<String, Map<String, String>>();
        int nextIndex = input.indexOf("");
        List<String> remainingList = input;
        if (remainingList.get(0).startsWith("E:")) {
            remainingList.set(0, "General");
        }
        while (nextIndex != -1 && !remainingList.get(0).equals("")) {
            List<String> subList = remainingList.subList(1, nextIndex);
            output.put(remainingList.get(0), MediaInfoHelper.processSubList(subList));
            if (nextIndex == remainingList.size() - 1) break;
            remainingList = remainingList.subList(nextIndex + 1, remainingList.size());
            nextIndex = remainingList.indexOf("");
        }
        return output;
    }

    protected static Map<String, String> processSubList(List<String> subList) {
        HashMap<String, String> subMap = new HashMap<String, String>();
        for (String singleInfoLine : subList) {
            if (singleInfoLine.length() < 3 || singleInfoLine.indexOf(":") < 1) continue;
            subMap.put(MediaInfoHelper.getSingleInfoKey(singleInfoLine), MediaInfoHelper.getSingleInfoValue(singleInfoLine));
        }
        return subMap;
    }

    protected static String getSingleInfoKey(String input) {
        return input.substring(0, input.indexOf(":")).trim();
    }

    protected static String getSingleInfoValue(String input) {
        return input.substring(input.indexOf(":") + 1).trim();
    }
}

