/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.mediainfo.mapper;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.labs.video.mediainfo.mapper.MediaInfoHelper;

@Operation(id="Blob.ExtractMediaMetadata", category="Files", label="Extract Metadata using Media Info", description="Extract the media file metadata using Media Info and store those in a context variable. If outputVariableJsonStr is passed, the JSON string of the result is stored in this variable.")
public class MediaInfoOp {
    public static final String ID = "Blob.ExtractMediaMetadata";
    @Context
    protected OperationContext ctx;
    @Param(name="outputVariable", required=false)
    protected String outputVariable;
    @Param(name="outputVariableJsonStr", required=false)
    protected String outputVariableJsonStr;

    @OperationMethod
    public Blob run(Blob blob) {
        if (StringUtils.isBlank((CharSequence)this.outputVariable) && StringUtils.isBlank((CharSequence)this.outputVariableJsonStr)) {
            throw new NuxeoException("At least one parameter must be passed");
        }
        Map<String, Map<String, String>> info = MediaInfoHelper.getProcessedMediaInfo(blob);
        if (StringUtils.isNotBlank((CharSequence)this.outputVariable)) {
            this.ctx.put(this.outputVariable, info);
        }
        if (StringUtils.isNotBlank((CharSequence)this.outputVariableJsonStr)) {
            this.ctx.put(this.outputVariableJsonStr, (Object)new JSONObject(info).toString());
        }
        return blob;
    }
}

