/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.mediainfo.mapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.video.service.VideoService;
import org.nuxeo.ecm.platform.video.service.VideoStoryboardWork;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class VideoInfoWorker
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(VideoInfoWorker.class);

    public VideoInfoWorker(String repositoryName, String docId) {
        super(repositoryName + ':' + docId + ":VideoInfo");
        this.setDocument(repositoryName, docId);
    }

    public void work() {
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.setStatus("Extracting");
        if (!TransactionHelper.isTransactionActive()) {
            this.startTransaction();
        }
        this.openSystemSession();
        if (!this.session.exists((DocumentRef)new IdRef(this.docId))) {
            this.setStatus("Nothing to process");
            return;
        }
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        Property origVideoProperty = doc.getProperty("file:content");
        Blob video = (Blob)origVideoProperty.getValue();
        if (video == null) {
            this.setStatus("Nothing to process");
            return;
        }
        this.updateVideoInfo(doc);
        this.session.saveDocument(doc);
        if (doc.hasFacet("HasVideoPreview") && doc.hasFacet("HasStoryboard")) {
            WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
            VideoStoryboardWork work = new VideoStoryboardWork(doc.getRepositoryName(), doc.getId());
            log.debug((Object)String.format("Scheduling work: storyboard of Video document %s.", doc));
            workManager.schedule((Work)work, true);
        }
        VideoService videoService = (VideoService)Framework.getService(VideoService.class);
        log.debug((Object)String.format("Launching automatic conversions of Video document %s.", doc));
        videoService.launchAutomaticConversions(doc);
        this.setStatus("Done");
    }

    public String getTitle() {
        return "VideoInfoWorker-" + this.docId;
    }

    public void updateVideoInfo(DocumentModel doc) throws NuxeoException {
        CoreSession session = doc.getCoreSession();
        AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext octx = new OperationContext();
        octx.setInput((Object)doc);
        octx.setCoreSession(session);
        OperationChain chain = new OperationChain("MediaInfoMappingWorker");
        chain.add("javascript.MediaInfoMapping");
        try {
            doc = (DocumentModel)as.run(octx, chain);
            session.saveDocument(doc);
        }
        catch (OperationException e) {
            log.error((Object)e);
            throw new NuxeoException((Throwable)e);
        }
    }
}

