/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.mediainfo.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.labs.video.mediainfo.mapper.MediaInfoHelper;

@Operation(id="Blob.ExtractMediaMetadata", category="Files", label="Extract Metadata using Media Info", description="Extract the media file metadata using Media Info and store those in a context variable. ")
public class MediaInfoOp {
    public static final String ID = "Blob.ExtractMediaMetadata";
    @Context
    protected OperationContext ctx;
    @Param(name="outputVariable", required=false)
    protected String outputVariable;
    @Param(name="outputVariableJsonStr", required=false)
    protected String outputVariableJsonStr;

    @OperationMethod
    public Blob run(Blob blob) throws JsonProcessingException {
        JsonNode info = MediaInfoHelper.getProcessedMediaInfo(blob);
        if (StringUtils.isNotBlank((CharSequence)this.outputVariable)) {
            ObjectMapper mapper = new ObjectMapper();
            Map result = (Map)mapper.convertValue((Object)info, (TypeReference)new TypeReference<Map<String, Object>>(){});
            this.ctx.put(this.outputVariable, (Object)result);
        }
        if (StringUtils.isNotBlank((CharSequence)this.outputVariableJsonStr)) {
            this.ctx.put(this.outputVariableJsonStr, (Object)info.toString());
        }
        return blob;
    }
}

