/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.mediainfo.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.runtime.api.Framework;

public class MediaInfoHelper {
    public static final String MEDIAINFO_INFO_COMMAND_LINE = "mediainfo-info";

    private MediaInfoHelper() {
    }

    public static JsonNode getProcessedMediaInfo(Blob video) throws NuxeoException, JsonProcessingException {
        return MediaInfoHelper.processMediaInfo(MediaInfoHelper.getRawMediaInfo(video));
    }

    public static List<String> getRawMediaInfo(Blob blob) throws NuxeoException {
        String uriStr = null;
        if (blob instanceof ManagedBlob) {
            ManagedBlob managedBlob = (ManagedBlob)blob;
            BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(blob);
            try {
                URI uri = blobProvider.getURI(managedBlob, BlobManager.UsageHint.DOWNLOAD, null);
                if (uri != null) {
                    uriStr = uri.toString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (uriStr == null) {
            try {
                File file = Framework.createTempFile((String)"mediainfo", (String)("." + FilenameUtils.getExtension((String)blob.getFilename())));
                blob.transferTo(file);
                uriStr = file.getAbsolutePath();
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        try {
            CommandLineExecutorService cleService = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
            CmdParameters params = new CmdParameters();
            params.addNamedParameter("url", uriStr);
            return cleService.execCommand(MEDIAINFO_INFO_COMMAND_LINE, params).getOutput();
        }
        catch (CommandNotAvailable e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public static JsonNode processMediaInfo(List<String> input) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.readTree(String.join((CharSequence)"", input));
    }
}

