/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.video.mediainfo.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.labs.video.mediainfo.mapper.MediaInfoHelper;

@Operation(id="Blob.ExtractMediaMetadata", category="Files", label="Extract Metadata using Media Info", description="Extract the media file metadata using Media Info and store those in a context variable. ")
public class MediaInfoOp {
    public static final String ID = "Blob.ExtractMediaMetadata";
    @Context
    protected OperationContext ctx;
    @Param(name="outputVariableJsonStr", required=true)
    protected String outputVariableJsonStr;

    @OperationMethod
    public Blob run(Blob blob) throws JsonProcessingException {
        JsonNode info = MediaInfoHelper.getProcessedMediaInfo(blob);
        this.ctx.put(this.outputVariableJsonStr, (Object)info.toString());
        return blob;
    }
}

