/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.vntana.automation;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.labs.vntana.service.VntanaService;

@Operation(id="Vntana.PublishModel", category="Vntana", label="Vnatana Publish Model", description="Publish a 3D model to Vntana")
public class VntanaPublishModel {
    public static final String ID = "Vntana.PublishModel";
    @Context
    protected CoreSession session;
    @Context
    protected VntanaService vntanaService;
    @Param(name="organizationUUID", required=false)
    protected String organizationUUID;
    @Param(name="clientUUID", required=false)
    protected String clientUUID;
    @Param(name="autoPublish", required=false)
    protected boolean autoPublish = false;
    @Param(name="save", required=false)
    protected boolean save = false;

    @OperationMethod
    public DocumentModel run(DocumentModel input) {
        input = !StringUtils.isBlank((CharSequence)this.organizationUUID) && !StringUtils.isBlank((CharSequence)this.clientUUID) ? this.vntanaService.publishModel(input, this.organizationUUID, this.clientUUID, this.autoPublish, null) : this.vntanaService.publishModel(input);
        if (this.save) {
            input = this.session.saveDocument(input);
        }
        return input;
    }
}

