/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.vntana.client.model;

import java.util.HashMap;
import java.util.Map;

public class ModelOpsParameters {
    public static final String OPTIMIZATION = "OPTIMIZATION";
    public static final String DRACO_COMPRESSION = "DRACO_COMPRESSION";
    public static final String TEXTURE_COMPRESSION = "TEXTURE_COMPRESSION";
    Map<String, Map<String, String>> parameters = new HashMap<String, Map<String, String>>();

    protected Map<String, String> getOptimization() {
        if (!this.parameters.containsKey(OPTIMIZATION)) {
            this.parameters.put(OPTIMIZATION, new HashMap());
        }
        return this.parameters.get(OPTIMIZATION);
    }

    protected Map<String, String> getDracoCompression() {
        if (!this.parameters.containsKey(DRACO_COMPRESSION)) {
            this.parameters.put(DRACO_COMPRESSION, new HashMap());
        }
        return this.parameters.get(DRACO_COMPRESSION);
    }

    protected Map<String, String> getTextureCompression() {
        if (!this.parameters.containsKey(TEXTURE_COMPRESSION)) {
            this.parameters.put(TEXTURE_COMPRESSION, new HashMap());
        }
        return this.parameters.get(TEXTURE_COMPRESSION);
    }

    public ModelOpsParameters setDracoCompression(boolean enabled) {
        this.getDracoCompression().put("enabled", Boolean.toString(enabled));
        return this;
    }

    public ModelOpsParameters setOptimizationDesiredOuput(String value) {
        this.getOptimization().put("desiredOutput", value);
        return this;
    }

    public ModelOpsParameters setOptimizationPolyCount(long count) {
        this.getOptimization().put("poly", Long.toString(count));
        return this;
    }

    public ModelOpsParameters setOptimizationObstructedGeometry(boolean enabled) {
        this.getOptimization().put("obstructedGeometry", Boolean.toString(enabled));
        return this;
    }

    public ModelOpsParameters setTextureLosslessCompression(boolean lossless) {
        this.getTextureCompression().put("lossless", Boolean.toString(lossless));
        return this;
    }

    public ModelOpsParameters setTextureAgression(int value) {
        this.getTextureCompression().put("aggression", Integer.toString(value));
        return this;
    }

    public ModelOpsParameters setTextureMaxDimension(int value) {
        this.getTextureCompression().put("maxDimension", Integer.toString(value));
        return this;
    }

    public Map<String, Map<String, String>> toMap() {
        return this.parameters;
    }
}

