/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.vntana.webhooks.endpoint;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.util.buf.HexUtils;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.labs.vntana.webhooks.events.VntanaEvent;
import org.nuxeo.runtime.api.Framework;

@Path(value="/vntana")
@WebObject(type="vntana")
@Consumes(value={"application/json"})
public class VntanaWebhookEndpoint
extends ModuleRoot {
    private static final Logger log = LogManager.getLogger(VntanaWebhookEndpoint.class);
    public static final String HEADER_VNTANA_SIGNATURE = "X-VNTANA-SIGNATURE";
    public static final String HEADER_TIMESTAMP = "X-TIMESTAMP";
    public static final String VNTANA_WEBHOOK_SECRET_PROPERTY = "vntana.webhook.secret";
    public static final String ALGORITHM = "HmacSHA256";
    public static final String VNTANA_EVENT = "vntanaEvent";
    protected static final ObjectMapper objectMapper = new ObjectMapper();

    @Path(value="/event")
    @POST
    public Object doPost(@Context HttpServletRequest request) {
        try {
            String requestBody = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
            String timestamp = request.getHeader(HEADER_TIMESTAMP);
            String signature = request.getHeader(HEADER_VNTANA_SIGNATURE);
            String secret = Framework.getProperty((String)VNTANA_WEBHOOK_SECRET_PROPERTY);
            if (StringUtils.isBlank((CharSequence)secret)) {
                log.debug("Vntana webhook secret is not set");
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
            if (!this.isValidSignature(timestamp, requestBody, secret, signature).booleanValue()) {
                log.debug("Wrong signature from Vnatana");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            VntanaEvent event = (VntanaEvent)objectMapper.readValue(requestBody, VntanaEvent.class);
            EventContextImpl ctx = new EventContextImpl(new Object[0]);
            Map<String, VntanaEvent> props = Collections.singletonMap(VNTANA_EVENT, event);
            ctx.setProperties(props);
            EventService es = (EventService)Framework.getService(EventService.class);
            es.fireEvent(VNTANA_EVENT, (EventContext)ctx);
        }
        catch (JsonProcessingException e) {
            log.error("Error processing the event", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            log.error("Error processing the event", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public Boolean isValidSignature(String timestamp, String payload, String secret, String signature) throws Exception {
        String calcSignature = VntanaWebhookEndpoint.computeSignature(secret, timestamp, payload);
        return calcSignature.equals(signature);
    }

    public static String computeSignature(String secret, String timestamp, String payload) throws NoSuchAlgorithmException, InvalidKeyException {
        String data = String.join((CharSequence)"#", timestamp, payload);
        Mac sha256_HMAC = Mac.getInstance(ALGORITHM);
        SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), ALGORITHM);
        sha256_HMAC.init(secret_key);
        return HexUtils.toHexString((byte[])sha256_HMAC.doFinal(data.getBytes(StandardCharsets.UTF_8)));
    }
}

