/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.vntana.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.nuxeo.labs.vntana.client.JSON;
import org.nuxeo.labs.vntana.client.model.ConversionErrorModel;
import org.nuxeo.labs.vntana.client.model.ThreeDComponentsModel;

public class Model {
    public static final String SERIALIZED_NAME_UUID = "uuid";
    @SerializedName(value="uuid")
    private String uuid;
    public static final String SERIALIZED_NAME_CONVERSION_FORMAT = "conversionFormat";
    @SerializedName(value="conversionFormat")
    private ConversionFormatEnum conversionFormat;
    public static final String SERIALIZED_NAME_MODEL_BLOB_ID = "modelBlobId";
    @SerializedName(value="modelBlobId")
    private String modelBlobId;
    public static final String SERIALIZED_NAME_MODEL_SIZE = "modelSize";
    @SerializedName(value="modelSize")
    private Long modelSize;
    public static final String SERIALIZED_NAME_CONVERSION_STATUS = "conversionStatus";
    @SerializedName(value="conversionStatus")
    private ConversionStatusEnum conversionStatus;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private ConversionErrorModel error;
    public static final String SERIALIZED_NAME_OPTIMIZATION_THREE_D_COMPONENTS = "optimizationThreeDComponents";
    @SerializedName(value="optimizationThreeDComponents")
    private ThreeDComponentsModel optimizationThreeDComponents;
    public static final String SERIALIZED_NAME_ORIGINAL_THREE_D_COMPONENTS = "originalThreeDComponents";
    @SerializedName(value="originalThreeDComponents")
    private ThreeDComponentsModel originalThreeDComponents;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Model uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public Model conversionFormat(ConversionFormatEnum conversionFormat) {
        this.conversionFormat = conversionFormat;
        return this;
    }

    @Nullable
    public ConversionFormatEnum getConversionFormat() {
        return this.conversionFormat;
    }

    public void setConversionFormat(ConversionFormatEnum conversionFormat) {
        this.conversionFormat = conversionFormat;
    }

    public Model modelBlobId(String modelBlobId) {
        this.modelBlobId = modelBlobId;
        return this;
    }

    @Nullable
    public String getModelBlobId() {
        return this.modelBlobId;
    }

    public void setModelBlobId(String modelBlobId) {
        this.modelBlobId = modelBlobId;
    }

    public Model modelSize(Long modelSize) {
        this.modelSize = modelSize;
        return this;
    }

    @Nullable
    public Long getModelSize() {
        return this.modelSize;
    }

    public void setModelSize(Long modelSize) {
        this.modelSize = modelSize;
    }

    public Model conversionStatus(ConversionStatusEnum conversionStatus) {
        this.conversionStatus = conversionStatus;
        return this;
    }

    @Nullable
    public ConversionStatusEnum getConversionStatus() {
        return this.conversionStatus;
    }

    public void setConversionStatus(ConversionStatusEnum conversionStatus) {
        this.conversionStatus = conversionStatus;
    }

    public Model error(ConversionErrorModel error) {
        this.error = error;
        return this;
    }

    @Nullable
    public ConversionErrorModel getError() {
        return this.error;
    }

    public void setError(ConversionErrorModel error) {
        this.error = error;
    }

    public Model optimizationThreeDComponents(ThreeDComponentsModel optimizationThreeDComponents) {
        this.optimizationThreeDComponents = optimizationThreeDComponents;
        return this;
    }

    @Nullable
    public ThreeDComponentsModel getOptimizationThreeDComponents() {
        return this.optimizationThreeDComponents;
    }

    public void setOptimizationThreeDComponents(ThreeDComponentsModel optimizationThreeDComponents) {
        this.optimizationThreeDComponents = optimizationThreeDComponents;
    }

    public Model originalThreeDComponents(ThreeDComponentsModel originalThreeDComponents) {
        this.originalThreeDComponents = originalThreeDComponents;
        return this;
    }

    @Nullable
    public ThreeDComponentsModel getOriginalThreeDComponents() {
        return this.originalThreeDComponents;
    }

    public void setOriginalThreeDComponents(ThreeDComponentsModel originalThreeDComponents) {
        this.originalThreeDComponents = originalThreeDComponents;
    }

    public Model putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Model model = (Model)o;
        return Objects.equals(this.uuid, model.uuid) && Objects.equals((Object)this.conversionFormat, (Object)model.conversionFormat) && Objects.equals(this.modelBlobId, model.modelBlobId) && Objects.equals(this.modelSize, model.modelSize) && Objects.equals((Object)this.conversionStatus, (Object)model.conversionStatus) && Objects.equals(this.error, model.error) && Objects.equals(this.optimizationThreeDComponents, model.optimizationThreeDComponents) && Objects.equals(this.originalThreeDComponents, model.originalThreeDComponents) && Objects.equals(this.additionalProperties, model.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uuid, this.conversionFormat, this.modelBlobId, this.modelSize, this.conversionStatus, this.error, this.optimizationThreeDComponents, this.originalThreeDComponents, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Model {\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    conversionFormat: ").append(this.toIndentedString((Object)this.conversionFormat)).append("\n");
        sb.append("    modelBlobId: ").append(this.toIndentedString(this.modelBlobId)).append("\n");
        sb.append("    modelSize: ").append(this.toIndentedString(this.modelSize)).append("\n");
        sb.append("    conversionStatus: ").append(this.toIndentedString((Object)this.conversionStatus)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    optimizationThreeDComponents: ").append(this.toIndentedString(this.optimizationThreeDComponents)).append("\n");
        sb.append("    originalThreeDComponents: ").append(this.toIndentedString(this.originalThreeDComponents)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Model is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UUID) != null && !jsonObj.get(SERIALIZED_NAME_UUID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONVERSION_FORMAT) != null && !jsonObj.get(SERIALIZED_NAME_CONVERSION_FORMAT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONVERSION_FORMAT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `conversionFormat` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONVERSION_FORMAT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODEL_BLOB_ID) != null && !jsonObj.get(SERIALIZED_NAME_MODEL_BLOB_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MODEL_BLOB_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `modelBlobId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODEL_BLOB_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONVERSION_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_CONVERSION_STATUS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONVERSION_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `conversionStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONVERSION_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ERROR) != null && !jsonObj.get(SERIALIZED_NAME_ERROR).isJsonNull()) {
            ConversionErrorModel.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ERROR));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPTIMIZATION_THREE_D_COMPONENTS) != null && !jsonObj.get(SERIALIZED_NAME_OPTIMIZATION_THREE_D_COMPONENTS).isJsonNull()) {
            ThreeDComponentsModel.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_OPTIMIZATION_THREE_D_COMPONENTS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGINAL_THREE_D_COMPONENTS) != null && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_THREE_D_COMPONENTS).isJsonNull()) {
            ThreeDComponentsModel.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ORIGINAL_THREE_D_COMPONENTS));
        }
    }

    public static Model fromJson(String jsonString) throws IOException {
        return (Model)JSON.getGson().fromJson(jsonString, Model.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_UUID);
        openapiFields.add(SERIALIZED_NAME_CONVERSION_FORMAT);
        openapiFields.add(SERIALIZED_NAME_MODEL_BLOB_ID);
        openapiFields.add(SERIALIZED_NAME_MODEL_SIZE);
        openapiFields.add(SERIALIZED_NAME_CONVERSION_STATUS);
        openapiFields.add(SERIALIZED_NAME_ERROR);
        openapiFields.add(SERIALIZED_NAME_OPTIMIZATION_THREE_D_COMPONENTS);
        openapiFields.add(SERIALIZED_NAME_ORIGINAL_THREE_D_COMPONENTS);
        openapiRequiredFields = new HashSet();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ConversionFormatEnum {
        GLB("GLB"),
        USDZ("USDZ"),
        OPTIMIZED("OPTIMIZED"),
        FBX("FBX");

        private String value;

        private ConversionFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ConversionFormatEnum fromValue(String value) {
            for (ConversionFormatEnum b : ConversionFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ConversionFormatEnum> {
            public void write(JsonWriter jsonWriter, ConversionFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ConversionFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ConversionFormatEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ConversionStatusEnum {
        PENDING("PENDING"),
        CONVERTING("CONVERTING"),
        COMPLETED("COMPLETED"),
        FAILED("FAILED"),
        NO_ASSET("NO_ASSET"),
        TERMINATED("TERMINATED");

        private String value;

        private ConversionStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ConversionStatusEnum fromValue(String value) {
            for (ConversionStatusEnum b : ConversionStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ConversionStatusEnum> {
            public void write(JsonWriter jsonWriter, ConversionStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ConversionStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ConversionStatusEnum.fromValue(value);
            }
        }
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Model.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Model.class));
            return new TypeAdapter<Model>(){

                public void write(JsonWriter out, Model value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Model read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Model.validateJsonObject(jsonObj);
                    Model instance = (Model)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

