/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.vntana.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.nuxeo.labs.vntana.client.ApiCallback;
import org.nuxeo.labs.vntana.client.ApiClient;
import org.nuxeo.labs.vntana.client.ApiException;
import org.nuxeo.labs.vntana.client.ApiResponse;
import org.nuxeo.labs.vntana.client.Configuration;
import org.nuxeo.labs.vntana.client.Pair;
import org.nuxeo.labs.vntana.client.model.AdminCommonProductCreateRequest;
import org.nuxeo.labs.vntana.client.model.AdminCommonProductDeleteRequest;
import org.nuxeo.labs.vntana.client.model.AdminCommonProductHardDeleteRequest;
import org.nuxeo.labs.vntana.client.model.AdminCommonProductUpdateRequest;
import org.nuxeo.labs.vntana.client.model.ProductCreateResultResponseOk;
import org.nuxeo.labs.vntana.client.model.ProductDeleteResultResponseOk;
import org.nuxeo.labs.vntana.client.model.ProductGetResultResponseOk;
import org.nuxeo.labs.vntana.client.model.ProductHardDeleteResultResponseOk;
import org.nuxeo.labs.vntana.client.model.ProductUpdateResultResponseOk;

public class ProductsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProductsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createProductCall(AdminCommonProductCreateRequest adminCommonProductCreateRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AdminCommonProductCreateRequest localVarPostBody = adminCommonProductCreateRequest;
        String localVarPath = "/v1/products";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "*/*"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"tokenHeader"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createProductValidateBeforeCall(AdminCommonProductCreateRequest adminCommonProductCreateRequest, ApiCallback _callback) throws ApiException {
        if (adminCommonProductCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'adminCommonProductCreateRequest' when calling createProduct(Async)");
        }
        return this.createProductCall(adminCommonProductCreateRequest, _callback);
    }

    public ProductCreateResultResponseOk createProduct(AdminCommonProductCreateRequest adminCommonProductCreateRequest) throws ApiException {
        ApiResponse<ProductCreateResultResponseOk> localVarResp = this.createProductWithHttpInfo(adminCommonProductCreateRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ProductCreateResultResponseOk> createProductWithHttpInfo(AdminCommonProductCreateRequest adminCommonProductCreateRequest) throws ApiException {
        Call localVarCall = this.createProductValidateBeforeCall(adminCommonProductCreateRequest, null);
        Type localVarReturnType = new TypeToken<ProductCreateResultResponseOk>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createProductAsync(AdminCommonProductCreateRequest adminCommonProductCreateRequest, ApiCallback<ProductCreateResultResponseOk> _callback) throws ApiException {
        Call localVarCall = this.createProductValidateBeforeCall(adminCommonProductCreateRequest, _callback);
        Type localVarReturnType = new TypeToken<ProductCreateResultResponseOk>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteProductCall(AdminCommonProductDeleteRequest adminCommonProductDeleteRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AdminCommonProductDeleteRequest localVarPostBody = adminCommonProductDeleteRequest;
        String localVarPath = "/v1/products/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "*/*"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"tokenHeader"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProductValidateBeforeCall(AdminCommonProductDeleteRequest adminCommonProductDeleteRequest, ApiCallback _callback) throws ApiException {
        if (adminCommonProductDeleteRequest == null) {
            throw new ApiException("Missing the required parameter 'adminCommonProductDeleteRequest' when calling deleteProduct(Async)");
        }
        return this.deleteProductCall(adminCommonProductDeleteRequest, _callback);
    }

    public ProductDeleteResultResponseOk deleteProduct(AdminCommonProductDeleteRequest adminCommonProductDeleteRequest) throws ApiException {
        ApiResponse<ProductDeleteResultResponseOk> localVarResp = this.deleteProductWithHttpInfo(adminCommonProductDeleteRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ProductDeleteResultResponseOk> deleteProductWithHttpInfo(AdminCommonProductDeleteRequest adminCommonProductDeleteRequest) throws ApiException {
        Call localVarCall = this.deleteProductValidateBeforeCall(adminCommonProductDeleteRequest, null);
        Type localVarReturnType = new TypeToken<ProductDeleteResultResponseOk>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteProductAsync(AdminCommonProductDeleteRequest adminCommonProductDeleteRequest, ApiCallback<ProductDeleteResultResponseOk> _callback) throws ApiException {
        Call localVarCall = this.deleteProductValidateBeforeCall(adminCommonProductDeleteRequest, _callback);
        Type localVarReturnType = new TypeToken<ProductDeleteResultResponseOk>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call downloadModelCall(String productUuid, String conversionFormat, String clientUuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{productUuid}/download/model".replace("{productUuid}", this.localVarApiClient.escapeString(productUuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (conversionFormat != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("conversionFormat", conversionFormat));
        }
        if (clientUuid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("clientUuid", clientUuid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"*/*"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"tokenHeader"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadModelValidateBeforeCall(String productUuid, String conversionFormat, String clientUuid, ApiCallback _callback) throws ApiException {
        if (productUuid == null) {
            throw new ApiException("Missing the required parameter 'productUuid' when calling downloadModel(Async)");
        }
        if (conversionFormat == null) {
            throw new ApiException("Missing the required parameter 'conversionFormat' when calling downloadModel(Async)");
        }
        if (clientUuid == null) {
            throw new ApiException("Missing the required parameter 'clientUuid' when calling downloadModel(Async)");
        }
        return this.downloadModelCall(productUuid, conversionFormat, clientUuid, _callback);
    }

    public File downloadModel(String productUuid, String conversionFormat, String clientUuid) throws ApiException {
        ApiResponse<File> localVarResp = this.downloadModelWithHttpInfo(productUuid, conversionFormat, clientUuid);
        return localVarResp.getData();
    }

    public ApiResponse<File> downloadModelWithHttpInfo(String productUuid, String conversionFormat, String clientUuid) throws ApiException {
        Call localVarCall = this.downloadModelValidateBeforeCall(productUuid, conversionFormat, clientUuid, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call downloadModelAsync(String productUuid, String conversionFormat, String clientUuid, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.downloadModelValidateBeforeCall(productUuid, conversionFormat, clientUuid, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call downloadThumbnailCall(String productUuid, String clientUuid, String thumbnailBlobId, Integer width, Integer height, Boolean download, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{productUuid}/clients/{clientUuid}/thumbnails/{thumbnailBlobId}".replace("{productUuid}", this.localVarApiClient.escapeString(productUuid.toString())).replace("{clientUuid}", this.localVarApiClient.escapeString(clientUuid.toString())).replace("{thumbnailBlobId}", this.localVarApiClient.escapeString(thumbnailBlobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (width != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("width", width));
        }
        if (height != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("height", height));
        }
        if (download != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("download", download));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"*/*"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"tokenHeader"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadThumbnailValidateBeforeCall(String productUuid, String clientUuid, String thumbnailBlobId, Integer width, Integer height, Boolean download, ApiCallback _callback) throws ApiException {
        if (productUuid == null) {
            throw new ApiException("Missing the required parameter 'productUuid' when calling downloadThumbnail(Async)");
        }
        if (clientUuid == null) {
            throw new ApiException("Missing the required parameter 'clientUuid' when calling downloadThumbnail(Async)");
        }
        if (thumbnailBlobId == null) {
            throw new ApiException("Missing the required parameter 'thumbnailBlobId' when calling downloadThumbnail(Async)");
        }
        return this.downloadThumbnailCall(productUuid, clientUuid, thumbnailBlobId, width, height, download, _callback);
    }

    public File downloadThumbnail(String productUuid, String clientUuid, String thumbnailBlobId, Integer width, Integer height, Boolean download) throws ApiException {
        ApiResponse<File> localVarResp = this.downloadThumbnailWithHttpInfo(productUuid, clientUuid, thumbnailBlobId, width, height, download);
        return localVarResp.getData();
    }

    public ApiResponse<File> downloadThumbnailWithHttpInfo(String productUuid, String clientUuid, String thumbnailBlobId, Integer width, Integer height, Boolean download) throws ApiException {
        Call localVarCall = this.downloadThumbnailValidateBeforeCall(productUuid, clientUuid, thumbnailBlobId, width, height, download, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call downloadThumbnailAsync(String productUuid, String clientUuid, String thumbnailBlobId, Integer width, Integer height, Boolean download, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.downloadThumbnailValidateBeforeCall(productUuid, clientUuid, thumbnailBlobId, width, height, download, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getByUuidCall(String uuid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/products/{uuid}".replace("{uuid}", this.localVarApiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "*/*"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"tokenHeader"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getByUuidValidateBeforeCall(String uuid, ApiCallback _callback) throws ApiException {
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling getByUuid(Async)");
        }
        return this.getByUuidCall(uuid, _callback);
    }

    public ProductGetResultResponseOk getByUuid(String uuid) throws ApiException {
        ApiResponse<ProductGetResultResponseOk> localVarResp = this.getByUuidWithHttpInfo(uuid);
        return localVarResp.getData();
    }

    public ApiResponse<ProductGetResultResponseOk> getByUuidWithHttpInfo(String uuid) throws ApiException {
        Call localVarCall = this.getByUuidValidateBeforeCall(uuid, null);
        Type localVarReturnType = new TypeToken<ProductGetResultResponseOk>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getByUuidAsync(String uuid, ApiCallback<ProductGetResultResponseOk> _callback) throws ApiException {
        Call localVarCall = this.getByUuidValidateBeforeCall(uuid, _callback);
        Type localVarReturnType = new TypeToken<ProductGetResultResponseOk>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call hardDeleteCall(AdminCommonProductHardDeleteRequest adminCommonProductHardDeleteRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AdminCommonProductHardDeleteRequest localVarPostBody = adminCommonProductHardDeleteRequest;
        String localVarPath = "/v1/products/hard-delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "*/*"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"tokenHeader"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call hardDeleteValidateBeforeCall(AdminCommonProductHardDeleteRequest adminCommonProductHardDeleteRequest, ApiCallback _callback) throws ApiException {
        if (adminCommonProductHardDeleteRequest == null) {
            throw new ApiException("Missing the required parameter 'adminCommonProductHardDeleteRequest' when calling hardDelete(Async)");
        }
        return this.hardDeleteCall(adminCommonProductHardDeleteRequest, _callback);
    }

    public ProductHardDeleteResultResponseOk hardDelete(AdminCommonProductHardDeleteRequest adminCommonProductHardDeleteRequest) throws ApiException {
        ApiResponse<ProductHardDeleteResultResponseOk> localVarResp = this.hardDeleteWithHttpInfo(adminCommonProductHardDeleteRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ProductHardDeleteResultResponseOk> hardDeleteWithHttpInfo(AdminCommonProductHardDeleteRequest adminCommonProductHardDeleteRequest) throws ApiException {
        Call localVarCall = this.hardDeleteValidateBeforeCall(adminCommonProductHardDeleteRequest, null);
        Type localVarReturnType = new TypeToken<ProductHardDeleteResultResponseOk>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call hardDeleteAsync(AdminCommonProductHardDeleteRequest adminCommonProductHardDeleteRequest, ApiCallback<ProductHardDeleteResultResponseOk> _callback) throws ApiException {
        Call localVarCall = this.hardDeleteValidateBeforeCall(adminCommonProductHardDeleteRequest, _callback);
        Type localVarReturnType = new TypeToken<ProductHardDeleteResultResponseOk>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateProductCall(String uuid, AdminCommonProductUpdateRequest adminCommonProductUpdateRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AdminCommonProductUpdateRequest localVarPostBody = adminCommonProductUpdateRequest;
        String localVarPath = "/v1/products";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (uuid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uuid", uuid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "*/*"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"tokenHeader"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProductValidateBeforeCall(String uuid, AdminCommonProductUpdateRequest adminCommonProductUpdateRequest, ApiCallback _callback) throws ApiException {
        if (uuid == null) {
            throw new ApiException("Missing the required parameter 'uuid' when calling updateProduct(Async)");
        }
        if (adminCommonProductUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'adminCommonProductUpdateRequest' when calling updateProduct(Async)");
        }
        return this.updateProductCall(uuid, adminCommonProductUpdateRequest, _callback);
    }

    public ProductUpdateResultResponseOk updateProduct(String uuid, AdminCommonProductUpdateRequest adminCommonProductUpdateRequest) throws ApiException {
        ApiResponse<ProductUpdateResultResponseOk> localVarResp = this.updateProductWithHttpInfo(uuid, adminCommonProductUpdateRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ProductUpdateResultResponseOk> updateProductWithHttpInfo(String uuid, AdminCommonProductUpdateRequest adminCommonProductUpdateRequest) throws ApiException {
        Call localVarCall = this.updateProductValidateBeforeCall(uuid, adminCommonProductUpdateRequest, null);
        Type localVarReturnType = new TypeToken<ProductUpdateResultResponseOk>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateProductAsync(String uuid, AdminCommonProductUpdateRequest adminCommonProductUpdateRequest, ApiCallback<ProductUpdateResultResponseOk> _callback) throws ApiException {
        Call localVarCall = this.updateProductValidateBeforeCall(uuid, adminCommonProductUpdateRequest, _callback);
        Type localVarReturnType = new TypeToken<ProductUpdateResultResponseOk>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

