/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.vntana.service;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.labs.vntana.adapter.VntanaAdapter;
import org.nuxeo.labs.vntana.adapter.VntanaProductReference;
import org.nuxeo.labs.vntana.client.ApiClient;
import org.nuxeo.labs.vntana.client.ApiException;
import org.nuxeo.labs.vntana.client.JSON;
import org.nuxeo.labs.vntana.client.api.ClientsApi;
import org.nuxeo.labs.vntana.client.api.OrganizationsApi;
import org.nuxeo.labs.vntana.client.api.PipelinesApi;
import org.nuxeo.labs.vntana.client.api.ProductsApi;
import org.nuxeo.labs.vntana.client.api.UploadApi;
import org.nuxeo.labs.vntana.client.model.AdminCommonGCloudStorageProductAssetUploadSignUrlSessionRequest;
import org.nuxeo.labs.vntana.client.model.AdminCommonGCloudStorageResourceSettingsModel;
import org.nuxeo.labs.vntana.client.model.AdminCommonProductCreateRequest;
import org.nuxeo.labs.vntana.client.model.AdminCommonProductHardDeleteRequest;
import org.nuxeo.labs.vntana.client.model.GCloudStorageResourceCreateSignUrlSessionResponse;
import org.nuxeo.labs.vntana.client.model.GetClientOrganizationResponseModel;
import org.nuxeo.labs.vntana.client.model.GetClientOrganizationResultResponse;
import org.nuxeo.labs.vntana.client.model.GetOrganizationByUuidResponseModel;
import org.nuxeo.labs.vntana.client.model.GetOrganizationByUuidResultResponse;
import org.nuxeo.labs.vntana.client.model.GetUserClientOrganizationsResponseModel;
import org.nuxeo.labs.vntana.client.model.GetUserOrganizationsResponseModel;
import org.nuxeo.labs.vntana.client.model.Model;
import org.nuxeo.labs.vntana.client.model.ModelOpsParameters;
import org.nuxeo.labs.vntana.client.model.PipelinesResultResponse;
import org.nuxeo.labs.vntana.client.model.ProductCreateResponseModel;
import org.nuxeo.labs.vntana.client.model.ProductCreateResultResponseOk;
import org.nuxeo.labs.vntana.client.model.ProductGetResponseModel;
import org.nuxeo.labs.vntana.client.model.ProductGetResultResponseOk;
import org.nuxeo.labs.vntana.client.model.ProductHardDeleteResponseModel;
import org.nuxeo.labs.vntana.client.model.ProductHardDeleteResultResponseOk;
import org.nuxeo.labs.vntana.client.model.UserClientOrganizationResponse;
import org.nuxeo.labs.vntana.client.model.UserOrganizationResponse;
import org.nuxeo.labs.vntana.service.VntanaService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class VntanaServiceImpl
extends DefaultComponent
implements VntanaService {
    private static final Logger log = LogManager.getLogger(VntanaServiceImpl.class);
    public static final String VNTANA_API_TOKEN = "vntana.api.key";
    public static final String VNTANA_DEFAULT_ORGANIZATION_UUID = "vntana.api.default.organization";
    public static final String VNTANA_DEFAULT_CLIENT_UUID = "vntana.api.default.client";
    public static final String VNTANA_DEFAULT_PUBLISH_LIVE = "vntana.api.default.publish.live";
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    public static final String X_AUTH_TOKEN = "x-auth-token";
    public static final String VNTANA_TOKEN_CACHE_NAME = "vnatana_token_cache";
    public static final String VNTANA_DOCUMENT_FILTER_ID = "vntanaDocumentFilter";
    protected volatile ApiClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiClient getApiClient() {
        ApiClient result = this.client;
        if (result == null) {
            VntanaServiceImpl vntanaServiceImpl = this;
            synchronized (vntanaServiceImpl) {
                result = this.client;
                if (result == null) {
                    result = this.client = new ApiClient();
                    org.nuxeo.labs.vntana.client.JSON.setOffsetDateTimeFormat((DateTimeFormatter)new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).toFormatter().withZone(ZoneOffset.UTC));
                    this.client.addDefaultHeader("Origin", "www.nuxeo.com");
                }
            }
        }
        return result;
    }

    public ApiClient getApiClient(String token) {
        ApiClient client = this.getApiClient();
        client.setApiKey(token);
        return client;
    }

    @Override
    public void setApiClient(ApiClient client) {
        this.client = client;
    }

    @Override
    public ModelOpsParameters getDefaultModelOpsParameters() {
        return new ModelOpsParameters().setDracoCompression(true).setOptimizationDesiredOuput("AUTO").setOptimizationObstructedGeometry(false).setTextureLosslessCompression(false).setTextureAgression(4).setTextureMaxDimension(4096);
    }

    @Override
    public List<GetUserOrganizationsResponseModel> getOrganizations() {
        String apiToken = this.getApiToken();
        try {
            UserOrganizationResponse response = new OrganizationsApi(this.getApiClient(apiToken)).getUserOrganizations();
            if (Boolean.TRUE.equals(response.getSuccess())) {
                return response.getResponse().getGrid();
            }
            throw new NuxeoException(String.format("Could not get the list of organizations, %s", response.getErrors()));
        }
        catch (ApiException e) {
            throw new NuxeoException("Could not get the list of organizations", (Throwable)e);
        }
    }

    @Override
    public GetOrganizationByUuidResponseModel getOrganization(String organizationUUID) {
        String organizationToken = this.getOrganizationToken(organizationUUID);
        try {
            GetOrganizationByUuidResultResponse response = new OrganizationsApi(this.getApiClient(organizationToken)).getCurrentOrganization();
            if (Boolean.TRUE.equals(response.getSuccess())) {
                return response.getResponse();
            }
            throw new NuxeoException(String.format("Could not get organization %s, %s", organizationUUID, response.getErrors()));
        }
        catch (ApiException e) {
            throw new NuxeoException("Could not get organization " + organizationUUID, (Throwable)e);
        }
    }

    @Override
    public List<GetUserClientOrganizationsResponseModel> getClients(String organizationID) {
        try {
            String organizationToken = this.getOrganizationToken(organizationID);
            UserClientOrganizationResponse response = new ClientsApi(this.getApiClient(organizationToken)).getClientOrganizations();
            if (Boolean.TRUE.equals(response.getSuccess())) {
                return response.getResponse().getGrid();
            }
            throw new NuxeoException(String.format("Could not get the list of clients, %s", response.getErrors()));
        }
        catch (ApiException e) {
            throw new NuxeoException("Could not get the list of clients", (Throwable)e);
        }
    }

    @Override
    public GetClientOrganizationResponseModel getClient(String organizationUUID, String clientUUID) {
        try {
            String organizationToken = this.getOrganizationToken(organizationUUID);
            GetClientOrganizationResultResponse response = new ClientsApi(this.getApiClient(organizationToken)).getClient(clientUUID);
            if (Boolean.TRUE.equals(response.getSuccess())) {
                return response.getResponse();
            }
            throw new NuxeoException(String.format("Could not get client %s, %s", clientUUID, response.getErrors()));
        }
        catch (ApiException e) {
            throw new NuxeoException("Could not get client " + clientUUID, (Throwable)e);
        }
    }

    @Override
    public ProductGetResponseModel getProduct(VntanaProductReference productRef) {
        String organizationToken = this.getOrganizationToken(productRef.getOrganizationUUID());
        try {
            ProductGetResultResponseOk response = new ProductsApi(this.getApiClient(organizationToken)).getByUuid(productRef.getProductUUID());
            if (Boolean.TRUE.equals(response.getSuccess())) {
                return response.getResponse();
            }
            throw new NuxeoException(String.format("Could not fetch product: %s, %s", productRef.getProductUUID(), response.getErrors()));
        }
        catch (ApiException e) {
            throw new NuxeoException("Could not fetch product: " + productRef.getProductUUID(), (Throwable)e);
        }
    }

    @Override
    public List<Map<String, String>> getPipelines(String organizationId) {
        String organizationToken = this.getOrganizationToken(organizationId);
        try {
            PipelinesResultResponse response = new PipelinesApi(this.getApiClient(organizationToken)).getPipelines();
            if (Boolean.TRUE.equals(response.getSuccess())) {
                return response.getResponse().getPipelines();
            }
            throw new NuxeoException(String.format("Could not fetch pipelines for org: %s, %s", organizationId, response.getErrors()));
        }
        catch (ApiException e) {
            throw new NuxeoException("Could not fetch pipelines for org: " + organizationId, (Throwable)e);
        }
    }

    @Override
    public String getPipelineUUID(String organizationId, String name) {
        List<Map<String, String>> pipelines = this.getPipelines(organizationId);
        Optional<Map> pipeline = pipelines.stream().filter(item -> name.equals(item.get("name"))).findFirst();
        if (pipeline.isPresent()) {
            return (String)pipeline.get().get("uuid");
        }
        throw new NuxeoException(String.format("No pipeline found for %s %s", organizationId, name));
    }

    @Override
    public ProductCreateResponseModel createProduct(String name, String organizationUUID, String clientUUID, String pipelineUUID, ModelOpsParameters parameters, Map<String, String> attributes) {
        AdminCommonProductCreateRequest productCreateRequest = new AdminCommonProductCreateRequest();
        productCreateRequest.setClientUuid(clientUUID);
        productCreateRequest.setName(name);
        productCreateRequest.setPipelineUuid(pipelineUUID);
        productCreateRequest.setModelOpsParameters(parameters.toMap());
        productCreateRequest.setAttributes(attributes);
        productCreateRequest.setStatus(AdminCommonProductCreateRequest.StatusEnum.LIVE_INTERNAL);
        productCreateRequest.setPublishToStatus(AdminCommonProductCreateRequest.PublishToStatusEnum.LIVE_INTERNAL);
        try {
            String organizationToken = this.getOrganizationToken(organizationUUID);
            ProductCreateResultResponseOk response = new ProductsApi(this.getApiClient(organizationToken)).createProduct(productCreateRequest);
            if (Boolean.TRUE.equals(response.getSuccess())) {
                return response.getResponse();
            }
            throw new NuxeoException(String.format("Could not create product, %s", response.getErrors()));
        }
        catch (ApiException e) {
            throw new NuxeoException("Could not create product", (Throwable)e);
        }
    }

    public boolean upload(VntanaProductReference productRef, Blob blob) throws ApiException, IOException {
        String organizationToken = this.getOrganizationToken(productRef.getOrganizationUUID());
        AdminCommonGCloudStorageProductAssetUploadSignUrlSessionRequest urlRequest = new AdminCommonGCloudStorageProductAssetUploadSignUrlSessionRequest();
        urlRequest.setClientUuid(productRef.getClientUUID());
        urlRequest.setProductUuid(productRef.getProductUUID());
        AdminCommonGCloudStorageResourceSettingsModel resourceSettings = new AdminCommonGCloudStorageResourceSettingsModel();
        resourceSettings.setContentType(blob.getMimeType());
        resourceSettings.setOriginalName(blob.getFilename());
        resourceSettings.setOriginalSize(Long.valueOf(blob.getLength()));
        urlRequest.setResourceSettings(resourceSettings);
        GCloudStorageResourceCreateSignUrlSessionResponse urlResponse = new UploadApi(this.getApiClient(organizationToken)).createClientProductAssetUploadSignUrlSession(urlRequest);
        String location = urlResponse.getResponse().getLocation();
        ApiClient client = this.getApiClient();
        try (CloseableFile cfile = blob.getCloseableFile();){
            boolean bl;
            block12: {
                Request uploadRequest = new Request.Builder().url(location).header(X_AUTH_TOKEN, organizationToken).put(RequestBody.create((File)cfile.getFile(), (MediaType)MediaType.get((String)blob.getMimeType()))).build();
                Response response = client.getHttpClient().newCall(uploadRequest).execute();
                try {
                    bl = response.isSuccessful();
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return bl;
        }
    }

    public ProductHardDeleteResponseModel deleteProduct(String organizationUUID, String productUUID) {
        AdminCommonProductHardDeleteRequest productDeleteRequest = new AdminCommonProductHardDeleteRequest();
        productDeleteRequest.setUuid(productUUID);
        try {
            String organizationToken = this.getOrganizationToken(organizationUUID);
            ProductHardDeleteResultResponseOk response = new ProductsApi(this.getApiClient(organizationToken)).hardDelete(productDeleteRequest);
            if (Boolean.TRUE.equals(response.getSuccess())) {
                return response.getResponse();
            }
            throw new NuxeoException(String.format("Could not delete product %s, %s", productUUID, response.getErrors()));
        }
        catch (ApiException e) {
            throw new NuxeoException("Could not delete product " + productUUID, (Throwable)e);
        }
    }

    @Override
    public boolean documentIsSupported(DocumentModel doc) {
        ActionManager actionService = (ActionManager)Framework.getService(ActionManager.class);
        ELActionContext actionContext = new ELActionContext();
        actionContext.setCurrentDocument(doc);
        return actionService.checkFilter(VNTANA_DOCUMENT_FILTER_ID, (ActionContext)actionContext);
    }

    @Override
    public DocumentModel publishModel(DocumentModel doc) {
        return this.publishModel(doc, Framework.getProperty((String)VNTANA_DEFAULT_ORGANIZATION_UUID), Framework.getProperty((String)VNTANA_DEFAULT_CLIENT_UUID), this.getDefaultModelOpsParameters());
    }

    @Override
    public DocumentModel publishModel(DocumentModel doc, String organizationUUID, String clientUUID, ModelOpsParameters parameters) {
        if (!doc.hasFacet("Vntana")) {
            doc.addFacet("Vntana");
        }
        GetOrganizationByUuidResponseModel organization = this.getOrganization(organizationUUID);
        GetClientOrganizationResponseModel client = this.getClient(organizationUUID, clientUUID);
        String pipelineUUID = this.getPipelineUUID(organizationUUID, "Convert Only");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("NuxeoUuid", doc.getId());
        ProductCreateResponseModel product = this.createProduct((String)((Object)doc.getPropertyValue("dc:title")), organizationUUID, clientUUID, pipelineUUID, parameters != null ? parameters : this.getDefaultModelOpsParameters(), attributes);
        String productId = product.getUuid();
        VntanaAdapter vntanaAdapter = (VntanaAdapter)doc.getAdapter(VntanaAdapter.class);
        vntanaAdapter.setOrganizationUUID(organizationUUID).setOrganizationSlug(organization.getSlug()).setClientUUID(clientUUID).setClientSlug(client.getClientSlug()).setProductUUID(productId);
        ProductGetResponseModel emptyProduct = this.getProduct(vntanaAdapter);
        vntanaAdapter.setStatus(emptyProduct.getStatus().toString());
        try {
            Blob blob = vntanaAdapter.getOriginalBlob();
            if (this.upload(vntanaAdapter, blob)) {
                vntanaAdapter.setSourceDigest(blob.getDigest()).setUploadSuccessful();
            } else {
                vntanaAdapter.setUploadFailed();
            }
        }
        catch (IOException | ApiException e) {
            vntanaAdapter.setUploadFailed();
        }
        return vntanaAdapter.getDoc();
    }

    @Override
    public DocumentModel updateModelRemoteProcessingStatus(DocumentModel doc) {
        VntanaAdapter adapter = (VntanaAdapter)doc.getAdapter(VntanaAdapter.class);
        this.updateModelRemoteProcessingStatus(adapter);
        return adapter.getDoc();
    }

    public void updateModelRemoteProcessingStatus(VntanaAdapter adapter) {
        ProductGetResponseModel model = this.getProduct(adapter);
        adapter.setStatus(model.getStatus().getValue());
        adapter.setConversionStatus(model.getConversionStatus().getValue());
    }

    @Override
    public DocumentModel updateModel(DocumentModel doc) {
        VntanaAdapter vntanaAdapter = (VntanaAdapter)doc.getAdapter(VntanaAdapter.class);
        Blob blob = vntanaAdapter.getOriginalBlob();
        if (blob.getDigest().equals(vntanaAdapter.getSourceDigest()) && vntanaAdapter.isUploaded()) {
            return doc;
        }
        try {
            if (this.upload(vntanaAdapter, blob)) {
                vntanaAdapter.setSourceDigest(blob.getDigest()).setUploadSuccessful();
                this.updateModelRemoteProcessingStatus(vntanaAdapter);
            }
        }
        catch (IOException | ApiException e) {
            vntanaAdapter.setUploadFailed();
        }
        return vntanaAdapter.getDoc();
    }

    @Override
    public DocumentModel unpublishModel(DocumentModel doc) {
        VntanaAdapter adapter = (VntanaAdapter)doc.getAdapter(VntanaAdapter.class);
        this.deleteProduct(adapter.getOrganizationUUID(), adapter.getProductUUID());
        doc.removeFacet("Vntana");
        return doc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Blob download(DocumentModel doc, Model.ConversionFormatEnum format) {
        VntanaAdapter adapter = (VntanaAdapter)doc.getAdapter(VntanaAdapter.class);
        String organizationToken = this.getOrganizationToken(adapter.getOrganizationUUID());
        try (Response response = new ProductsApi(this.getApiClient(organizationToken)).downloadModelCall(adapter.getProductUUID(), format.getValue(), adapter.getClientUUID(), null).execute();){
            if (response.isSuccessful()) {
                Blob blob = this.downloadFile(response);
                return blob;
            }
            throw new NuxeoException(String.format("Failed to download format %s for doc %s: %s", format.getValue(), doc.getId(), response));
        }
        catch (IOException | ApiException e) {
            throw new NuxeoException("Failed to download", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Blob thumbnail(DocumentModel doc) {
        VntanaAdapter adapter = this.getAdapter(doc);
        ProductGetResponseModel productModel = this.getProduct((VntanaProductReference)doc.getAdapter(VntanaAdapter.class));
        String thumbnailBlobId = productModel.getAsset().getThumbnailBlobId();
        if (thumbnailBlobId == null) {
            log.debug(String.format("No Thumbnail ID for vntana product %s in doc %s", productModel.getUuid(), doc.getId()));
            return null;
        }
        String organizationToken = this.getOrganizationToken(adapter.getOrganizationUUID());
        try (Response response = new ProductsApi(this.getApiClient(organizationToken)).downloadThumbnailCall(adapter.getProductUUID(), adapter.getClientUUID(), thumbnailBlobId, null, null, Boolean.valueOf(true), null).execute();){
            if (response.isSuccessful()) {
                Blob blob = this.downloadFile(response);
                return blob;
            }
            throw new NuxeoException(String.format("Failed to download thumbnail for doc %s: %s", doc.getId(), response));
        }
        catch (IOException | ApiException e) {
            throw new NuxeoException("Failed to download", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getApiToken() {
        String apiKey = Framework.getProperty((String)VNTANA_API_TOKEN);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new NuxeoException("Vntana API key is not set");
        }
        Object apiToken = this.getTokenFromCache(apiKey);
        if (apiToken != null) {
            return apiToken;
        }
        try {
            Request request = new Request.Builder().url("https://api-platform.vntana.com/v1/auth/login/token").post(RequestBody.create((String)String.format("{\n\"personal-access-token\": \"%s\"\n}", apiKey), (MediaType)JSON)).build();
            try (Response response = this.getApiClient().getHttpClient().newCall(request).execute();){
                if (!response.isSuccessful()) throw new NuxeoException("Could not initialize the vntana client");
                apiToken = "Bearer " + response.header(X_AUTH_TOKEN);
                this.putTokenInCache(apiKey, (String)apiToken);
                Object object = apiToken;
                return object;
            }
        }
        catch (IOException e) {
            throw new NuxeoException("Could not initialize the vntana client", (Throwable)e);
        }
    }

    protected String getOrganizationToken(String organizationId) {
        Object object;
        block10: {
            Object orgToken = this.getTokenFromCache(organizationId);
            if (orgToken != null) {
                return orgToken;
            }
            String apiToken = this.getApiToken();
            ApiClient client = this.getApiClient();
            Request request = new Request.Builder().url("https://api-platform.vntana.com/v1/auth/refresh-token").header(X_AUTH_TOKEN, apiToken).header("organizationUuid", organizationId).method("POST", RequestBody.create((byte[])new byte[0])).build();
            Response authResponse = client.getHttpClient().newCall(request).execute();
            try {
                if (!authResponse.isSuccessful()) {
                    throw new NuxeoException("Could not authenticate for organization " + organizationId);
                }
                orgToken = "Bearer " + authResponse.header(X_AUTH_TOKEN);
                this.putTokenInCache(organizationId, (String)orgToken);
                object = orgToken;
                if (authResponse == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (authResponse != null) {
                        try {
                            authResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NuxeoException("Could not authenticate for organization " + organizationId, (Throwable)e);
                }
            }
            authResponse.close();
        }
        return object;
    }

    protected String getTokenFromCache(String key) {
        CacheService cacheService = (CacheService)Framework.getService(CacheService.class);
        Cache cache = cacheService.getCache(VNTANA_TOKEN_CACHE_NAME);
        return (String)((Object)cache.get(key));
    }

    protected void putTokenInCache(String key, String token) {
        CacheService cacheService = (CacheService)Framework.getService(CacheService.class);
        Cache cache = cacheService.getCache(VNTANA_TOKEN_CACHE_NAME);
        cache.put(key, (Serializable)((Object)token));
    }

    protected VntanaAdapter getAdapter(DocumentModel doc) {
        return (VntanaAdapter)doc.getAdapter(VntanaAdapter.class);
    }

    protected Blob downloadFile(Response response) throws ApiException {
        Pattern pattern;
        Matcher matcher;
        File file = this.getApiClient().downloadFileFromResponse(response);
        String contentDisposition = response.header("Content-Disposition");
        String filename = null;
        if (StringUtils.isNotBlank((CharSequence)contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\";]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = this.getApiClient().sanitizeFilename(matcher.group(1));
        }
        FileBlob blob = new FileBlob(file, response.headers().get("content-type"));
        if (StringUtils.isNotBlank(filename)) {
            blob.setFilename(filename);
        }
        return blob;
    }
}

