/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.vntana.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.labs.vntana.adapter.VntanaProductReference;
import org.nuxeo.runtime.api.Framework;

public class VntanaAdapter
implements VntanaProductReference {
    public static final String RENDITION_PREFIX = "//rendition:";
    public static final String VNTANA_FACET = "Vntana";
    public static final String VNTANA_ORG_UUID_PROPERTY = "vntana:organization_uuid";
    public static final String VNTANA_ORG_SLUG_PROPERTY = "vntana:organization_slug";
    public static final String VNTANA_CLIENT_UUID_PROPERTY = "vntana:client_uuid";
    public static final String VNTANA_CLIENT_SLUG_PROPERTY = "vntana:client_slug";
    public static final String VNTANA_PRODUCT_PROPERTY = "vntana:product_uuid";
    public static final String VNTANA_STATUS_PROPERTY = "vntana:status";
    public static final String VNTANA_CONVERSION_STATUS_PROPERTY = "vntana:conversion_status";
    public static final String VNTANA_SOURCE_DIGEST_PROPERTY = "vntana:source_digest";
    public static final String VNTANA_UPLOAD_STATUS_PROPERTY = "vntana:upload_status";
    protected DocumentModel doc;

    public VntanaAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    public DocumentModel getDoc() {
        return this.doc;
    }

    @Override
    public String getOrganizationUUID() {
        return (String)((Object)this.doc.getPropertyValue(VNTANA_ORG_UUID_PROPERTY));
    }

    public VntanaAdapter setOrganizationUUID(String organizationUUID) {
        this.doc.setPropertyValue(VNTANA_ORG_UUID_PROPERTY, (Serializable)((Object)organizationUUID));
        return this;
    }

    public String getOrganizationSlug() {
        return (String)((Object)this.doc.getPropertyValue(VNTANA_ORG_SLUG_PROPERTY));
    }

    public VntanaAdapter setOrganizationSlug(String organizationSlug) {
        this.doc.setPropertyValue(VNTANA_ORG_SLUG_PROPERTY, (Serializable)((Object)organizationSlug));
        return this;
    }

    @Override
    public String getClientUUID() {
        return (String)((Object)this.doc.getPropertyValue(VNTANA_CLIENT_UUID_PROPERTY));
    }

    public VntanaAdapter setClientUUID(String clientUUID) {
        this.doc.setPropertyValue(VNTANA_CLIENT_UUID_PROPERTY, (Serializable)((Object)clientUUID));
        return this;
    }

    public String getClientSlug() {
        return (String)((Object)this.doc.getPropertyValue(VNTANA_CLIENT_SLUG_PROPERTY));
    }

    public VntanaAdapter setClientSlug(String clientSlug) {
        this.doc.setPropertyValue(VNTANA_CLIENT_SLUG_PROPERTY, (Serializable)((Object)clientSlug));
        return this;
    }

    @Override
    public String getProductUUID() {
        return (String)((Object)this.doc.getPropertyValue(VNTANA_PRODUCT_PROPERTY));
    }

    public VntanaAdapter setProductUUID(String productUUID) {
        this.doc.setPropertyValue(VNTANA_PRODUCT_PROPERTY, (Serializable)((Object)productUUID));
        return this;
    }

    public String getStatus() {
        return (String)((Object)this.doc.getPropertyValue(VNTANA_STATUS_PROPERTY));
    }

    public VntanaAdapter setStatus(String status) {
        this.doc.setPropertyValue(VNTANA_STATUS_PROPERTY, (Serializable)((Object)status));
        return this;
    }

    public String getConversionStatus() {
        return (String)((Object)this.doc.getPropertyValue(VNTANA_CONVERSION_STATUS_PROPERTY));
    }

    public VntanaAdapter setConversionStatus(String status) {
        this.doc.setPropertyValue(VNTANA_CONVERSION_STATUS_PROPERTY, (Serializable)((Object)status));
        return this;
    }

    public String getSourceDigest() {
        return (String)((Object)this.doc.getPropertyValue(VNTANA_SOURCE_DIGEST_PROPERTY));
    }

    public VntanaAdapter setSourceDigest(String digest) {
        this.doc.setPropertyValue(VNTANA_SOURCE_DIGEST_PROPERTY, (Serializable)((Object)digest));
        return this;
    }

    public String getUploadStatus() {
        return (String)((Object)this.doc.getPropertyValue(VNTANA_UPLOAD_STATUS_PROPERTY));
    }

    public VntanaAdapter setUploadStatus(String status) {
        this.doc.setPropertyValue(VNTANA_UPLOAD_STATUS_PROPERTY, (Serializable)((Object)status));
        return this;
    }

    public boolean isUploaded() {
        return UploadStatusEnum.SUCCESS.getValue().equals(this.doc.getPropertyValue(VNTANA_UPLOAD_STATUS_PROPERTY));
    }

    public VntanaAdapter setUploadSuccessful() {
        this.setUploadStatus(UploadStatusEnum.SUCCESS.value);
        this.setConversionStatus("PENDING");
        return this;
    }

    public boolean isNotUploaded() {
        return UploadStatusEnum.FAILED.getValue().equals(this.doc.getPropertyValue(VNTANA_UPLOAD_STATUS_PROPERTY));
    }

    public VntanaAdapter setUploadFailed() {
        this.setUploadStatus(UploadStatusEnum.FAILED.value);
        return this;
    }

    public Blob getOriginalBlob() {
        String fileProperty = Framework.getProperty((String)String.format("vntana.%s.file.xpath", this.doc.getType().toLowerCase()), (String)"file:content");
        if (fileProperty.startsWith(RENDITION_PREFIX)) {
            String renditionName = fileProperty.substring(RENDITION_PREFIX.length());
            RenditionService renditionService = (RenditionService)Framework.getService(RenditionService.class);
            Blob blob = renditionService.getRendition(this.doc, renditionName).getBlob();
            if (blob.getDigest() == null) {
                try (InputStream in = blob.getStream();){
                    String digest = new DigestUtils("MD5").digestAsHex(in);
                    blob.setDigest(digest);
                }
                catch (IOException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            return blob;
        }
        return (Blob)this.doc.getPropertyValue(fileProperty);
    }

    public VntanaAdapter save() {
        CoreSession session = this.doc.getCoreSession();
        this.doc = session.saveDocument(this.doc);
        return this;
    }

    public static enum UploadStatusEnum {
        SUCCESS("SUCCESS"),
        FAILED("FAILED");

        private final String value;

        private UploadStatusEnum(String value) {
            this.value = value;
        }

        public static UploadStatusEnum fromValue(String value) {
            for (UploadStatusEnum b : UploadStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

