/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.vntana.enricher;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.labs.vntana.service.VntanaService;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class VntanaEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "vntana";

    public VntanaEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel obj) throws IOException {
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(obj);){
            if (!wrapper.getSession().exists(obj.getRef())) {
                return;
            }
            VntanaService service = (VntanaService)Framework.getService(VntanaService.class);
            jg.writeFieldName(NAME);
            jg.writeStartObject();
            jg.writeBooleanField("isSupported", service.documentIsSupported(obj));
            jg.writeEndObject();
        }
    }
}

