/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.threed.obj.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.io.fsexporter.FSExporterService;
import org.nuxeo.labs.threed.obj.service.WavefrontObjConversionService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class WavefrontObjConversionServiceImpl
extends DefaultComponent
implements WavefrontObjConversionService {
    @Override
    public Blob convert(DocumentModel doc) {
        try {
            return doc.isFolder() ? this.convertFolderish(doc) : this.convertSingleDocument(doc);
        }
        catch (IOException | CommandNotAvailable e) {
            throw new NuxeoException(e);
        }
    }

    public Blob convertFolderish(DocumentModel doc) throws IOException, CommandNotAvailable {
        File glbFile;
        Path tmpFolder = Framework.createTempDirectory((String)"obj_conversion", (FileAttribute[])new FileAttribute[0]);
        FSExporterService fsExporter = (FSExporterService)Framework.getService(FSExporterService.class);
        fsExporter.export(doc.getCoreSession(), doc.getPathAsString(), tmpFolder.toString(), null);
        Path tmpDocFolder = Paths.get(tmpFolder.toString(), doc.getName());
        Optional<File> objFile = Arrays.stream(tmpDocFolder.toFile().listFiles()).filter(file -> FilenameUtils.isExtension((String)file.getName(), (String)"obj")).findFirst();
        if (objFile.isEmpty()) {
            throw new NuxeoException("No OBJ file found in structure");
        }
        CommandLineExecutorService cs = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        CmdParameters parameters = new CmdParameters();
        parameters.addNamedParameter("sourceFilePath", objFile.get().getAbsolutePath());
        String targetPath = tmpFolder.toFile().getAbsolutePath() + "/preview.glb";
        parameters.addNamedParameter("targetFilePath", targetPath);
        ExecResult result = cs.execCommand("obj2gltf", parameters);
        if (result.isSuccessful() && (glbFile = new File(targetPath)).exists()) {
            return new FileBlob(new File(targetPath), "model/gltf-binary");
        }
        throw new NuxeoException("OBJ to GLB conversion failed");
    }

    public Blob convertSingleDocument(DocumentModel doc) {
        Blob blob = (Blob)doc.getPropertyValue("file:content");
        SimpleBlobHolder input = new SimpleBlobHolder(blob);
        ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("targetFileName", "preview.glb");
        BlobHolder output = cs.convert("obj2gltf", (BlobHolder)input, params);
        return output.getBlob();
    }
}

