/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.threed.obj.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.labs.threed.obj.adapter.Blob2GlbResourceAdapter;
import org.nuxeo.labs.threed.obj.service.WavefrontObjConversionService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class WavefrontObjConversionServiceImpl
extends DefaultComponent
implements WavefrontObjConversionService {
    @Override
    public Blob convert(DocumentModel doc) {
        try {
            Blob blob = doc.isFolder() ? this.convertFolderish(doc) : this.convertSingleDocument(doc);
            ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("targetFileName", blob.getFilename());
            BlobHolder conversionResult = conversionService.convert("draco", (BlobHolder)new SimpleBlobHolder(blob), params);
            return conversionResult.getBlob();
        }
        catch (IOException | CommandNotAvailable e) {
            throw new NuxeoException(e);
        }
    }

    public Blob convertFolderish(DocumentModel doc) throws IOException, CommandNotAvailable {
        File glbFile;
        Path tmpFolder = Framework.createTempDirectory((String)"obj_conversion", (FileAttribute[])new FileAttribute[0]);
        PageProviderService pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)doc.getCoreSession());
        PageProvider pp = pageProviderService.getPageProvider("obj_components", null, null, null, null, props, new Object[]{doc.getId()});
        HashMap<String, Path> folderPaths = new HashMap<String, Path>();
        folderPaths.put(doc.getPathAsString(), tmpFolder);
        do {
            List children = pp.getCurrentPage();
            for (DocumentModel current : children) {
                File file2;
                Path parent = (Path)folderPaths.get(current.getPath().removeLastSegments(1).toString());
                if (current.isFolder()) {
                    File folder = new File(Path.of(parent.toString(), (String)((Object)current.getPropertyValue("dc:title"))).toString());
                    if (folder.createNewFile()) continue;
                    throw new IOException("Could not create tmp folder " + folder.getPath());
                }
                Blob blob = ((Blob2GlbResourceAdapter)current.getAdapter(Blob2GlbResourceAdapter.class)).getBlob();
                if (blob == null) continue;
                String name = (String)((Object)current.getPropertyValue("dc:title"));
                if (name == null) {
                    name = current.getName();
                }
                if ((file2 = new File(Path.of(parent.toString(), name).toString())).createNewFile()) {
                    InputStream in = blob.getStream();
                    try {
                        FileOutputStream out = new FileOutputStream(file2);
                        try {
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                            continue;
                        }
                        finally {
                            ((OutputStream)out).close();
                            continue;
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                        continue;
                    }
                }
                throw new IOException("Could not create tmp file " + file2.getPath());
            }
            pp.nextPage();
        } while (pp.isNextEntryAvailable());
        File[] files = tmpFolder.toFile().listFiles();
        if (files == null) {
            throw new NuxeoException("Cannot list tmp file structure");
        }
        Optional<File> objFile = Arrays.stream(files).filter(file -> FilenameUtils.isExtension((String)file.getName(), (String)"obj")).findFirst();
        if (objFile.isEmpty()) {
            throw new NuxeoException("No OBJ file found in structure");
        }
        CommandLineExecutorService cs = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        CmdParameters parameters = new CmdParameters();
        parameters.addNamedParameter("sourceFilePath", objFile.get().getAbsolutePath());
        String targetPath = tmpFolder.toFile().getAbsolutePath() + "/preview.glb";
        parameters.addNamedParameter("targetFilePath", targetPath);
        ExecResult result = cs.execCommand("obj2gltf", parameters);
        if (result.isSuccessful() && (glbFile = new File(targetPath)).exists()) {
            return new FileBlob(new File(targetPath), "model/gltf-binary");
        }
        throw new NuxeoException("OBJ to GLB conversion failed");
    }

    public Blob convertSingleDocument(DocumentModel doc) {
        Blob blob = (Blob)doc.getPropertyValue("file:content");
        SimpleBlobHolder input = new SimpleBlobHolder(blob);
        ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("targetFileName", "preview.glb");
        BlobHolder output = cs.convert("obj2gltf", (BlobHolder)input, params);
        return output.getBlob();
    }
}

