/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.webengine.document;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.mobile.webengine.adapter.JSonExportAdapter;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.preview.helper.PreviewHelper;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.ResourceType;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.runtime.api.Framework;

public class MobileDocument
extends DocumentObject {
    private static final Log log = LogFactory.getLog(MobileDocument.class);
    private AutomationService automationService;
    private String nuxeoContextPath;
    private DocumentViewCodecManager codecManager;

    public MobileDocument(WebContext ctx, DocumentRef docRef) {
        try {
            ResourceType resType = ctx.getModule().getType("Document");
            DocumentModel docModel = ctx.getCoreSession().getDocument(docRef);
            this.initialize(ctx, resType, new Object[]{docModel});
            ctx.push((Resource)this);
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    @Path(value="@put")
    public Object redirectToRealURL() {
        String uri = this.ctx.getRequest().getRequestURI();
        uri = uri.substring(0, uri.length() - "@put".length() - 1);
        String queryString = this.ctx.getRequest().getQueryString();
        return this.redirect(uri + (queryString != null ? "?" + queryString : ""));
    }

    @GET
    @Path(value="mailIt")
    public Object doMailIt() {
        try {
            OperationContext subctx = new OperationContext(this.ctx.getCoreSession(), null);
            subctx.setInput((Object)this.getDocument());
            this.getAutomationService().run(subctx, "sendEmailToMe");
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return Response.status((int)400).build();
        }
        return Response.ok().build();
    }

    @Path(value="like")
    public Object doLike() {
        try {
            return this.ctx.newObject("Like", new Object[]{this.getDocument()});
        }
        catch (Exception e) {
            log.debug((Object)e, (Throwable)e);
            return this.ctx.newObject("Empty", new Object[0]);
        }
    }

    @Path(value="hasLiked")
    public Object doHasLiked() {
        try {
            return this.ctx.newObject("hasLiked", new Object[]{this.getDocument()});
        }
        catch (Exception e) {
            log.debug((Object)e, (Throwable)e);
            return this.ctx.newObject("Empty", new Object[0]);
        }
    }

    public Object doGet() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        HttpServletRequest request = this.ctx.getRequest();
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "view";
        }
        if (request.getParameter("targetURL") != null) {
            String mobileURL = String.format("%s/doc/%s?mode=%s", this.ctx.getRoot().getPath(), this.doc.getId(), mode);
            args.put("mobileURL", mobileURL);
        }
        args.put("hasBlob", this.getHasBlob());
        JSonExportAdapter json = (JSonExportAdapter)this.ctx.newObject("JSONExport", new Object[0]);
        args.put("doc", json.doGet(request.getRequestURI(), "post"));
        return this.getView(mode).args(args);
    }

    protected boolean getHasBlob() {
        DocumentModel doc = this.getDocument();
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        try {
            return bh != null && bh.getBlob() != null;
        }
        catch (ClientException e) {
            log.debug((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean hasPreview() throws PropertyException, ClientException {
        if (this.doc.hasSchema("file") && this.doc.getPropertyValue("file:content") != null) {
            return PreviewHelper.typeSupportsPreview((DocumentModel)this.doc);
        }
        return false;
    }

    public NuxeoPrincipal getPrincipal() {
        if (this.ctx.getPrincipal() instanceof NuxeoPrincipal) {
            return (NuxeoPrincipal)this.ctx.getPrincipal();
        }
        throw new WebException("Principal found is not a NuxeoPrincipal can't generate it!");
    }

    public String getJSFURLPath(DocumentModel docModel) throws Exception {
        DocumentViewImpl view = new DocumentViewImpl(docModel);
        return this.getCodecManager().getUrlFromDocumentView((DocumentView)view, true, NotificationServiceHelper.getNotificationService().getServerUrlPrefix());
    }

    public String getDownloadURL() throws Exception {
        DocumentModel docModel = this.getDocument();
        return this.getDownloadURL(docModel);
    }

    public String getDownloadURL(DocumentModel docModel) throws Exception {
        String filename = (String)((Object)this.doc.getPropertyValue("file:filename"));
        String mimetype = (String)((Object)this.doc.getPropertyValue("file:content/mime-type"));
        String downloadURL = this.getNuxeoContextPath() + "/";
        downloadURL = downloadURL + "nxbigfile/";
        downloadURL = downloadURL + this.doc.getRepositoryName() + "/";
        downloadURL = downloadURL + this.doc.getRef().toString() + "/";
        downloadURL = downloadURL + "blobholder:0/";
        downloadURL = downloadURL + filename;
        downloadURL = downloadURL + "?mimetype=" + mimetype;
        return downloadURL;
    }

    public String getJSFURLPath() throws Exception {
        return this.getJSFURLPath(this.getDocument());
    }

    public String getPreviewURL() {
        Resource targetObject = this.ctx.getTargetObject();
        if (!(targetObject instanceof MobileDocument)) {
            throw new WebException("Target Object must be MobileDocument");
        }
        return this.getNuxeoContextPath() + "/" + PreviewHelper.getPreviewURL((DocumentModel)((MobileDocument)targetObject).getDocument());
    }

    private String getNuxeoContextPath() {
        if (this.nuxeoContextPath == null) {
            this.nuxeoContextPath = Framework.getProperty((String)"org.nuxeo.ecm.contextPath");
        }
        return this.nuxeoContextPath;
    }

    private AutomationService getAutomationService() throws Exception {
        if (this.automationService == null) {
            this.automationService = (AutomationService)Framework.getService(AutomationService.class);
        }
        return this.automationService;
    }

    private DocumentViewCodecManager getCodecManager() throws Exception {
        if (this.codecManager == null) {
            this.codecManager = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        }
        return this.codecManager;
    }
}

