/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.filter;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.mobile.ApplicationDefinitionService;
import org.nuxeo.ecm.mobile.filter.RequestAdapter;
import org.nuxeo.ecm.platform.ui.web.auth.CachableUserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoAuthenticationFilter;
import org.nuxeo.runtime.api.Framework;

public class ApplicationRedirectionFilter
implements Filter {
    protected static final Log log = LogFactory.getLog(ApplicationRedirectionFilter.class);
    public static final String INITIAL_TARGET_URL_PARAM_NAME = "targetURL";
    private ApplicationDefinitionService service;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.service == null) {
            this.service = (ApplicationDefinitionService)Framework.getLocalService(ApplicationDefinitionService.class);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            log.debug((Object)"Not an Http request, no redirection");
            this.doNoRedirect(request, response, chain);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        log.debug((Object)("do filter - URL :" + req.getRequestURL() + "?" + req.getQueryString()));
        if (!this.isAuthenticated(req)) {
            log.debug((Object)"User not authenticated so no application redirection");
            this.doNoRedirect(request, response, chain);
            return;
        }
        String targetApplicationBaseURL = this.service.getApplicationBaseURL(req);
        if (targetApplicationBaseURL == null) {
            log.debug((Object)("No application match this request context => no redirect: final URL: " + req.getRequestURI()));
            this.doNoRedirect(request, response, chain);
            return;
        }
        if (this.isRequestIntoApplication(req, targetApplicationBaseURL)) {
            log.debug((Object)("Request URI is a child of target application so no redirect: final URL: " + req.getRequestURI()));
            this.doNoRedirect(request, response, chain);
            return;
        }
        if (this.service.isResourceURL(req)) {
            log.debug((Object)("Request URI is a resource of the target application so no redirect: final URL: " + req.getRequestURI()));
            this.doNoRedirect(request, response, chain);
            return;
        }
        RequestAdapter requestAdapter = new RequestAdapter(req);
        if (requestAdapter.isOpenURL()) {
            log.debug((Object)("Request URI is opened so no redirect: final URL: " + req.getRequestURI()));
            this.doNoRedirect(request, response, chain);
            return;
        }
        this.doApplicationRedirection((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private boolean isAuthenticated(HttpServletRequest req) {
        if (req.getSession() == null) {
            return false;
        }
        CachableUserIdentificationInfo idInfo = (CachableUserIdentificationInfo)req.getSession().getAttribute("org.nuxeo.ecm.login.identity");
        return idInfo != null && idInfo.getPrincipal() != null;
    }

    private void doApplicationRedirection(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(INITIAL_TARGET_URL_PARAM_NAME, NuxeoAuthenticationFilter.getRequestedPage((ServletRequest)request));
        String redirectURI = URIUtils.addParametersToURIQuery((String)this.service.getApplicationBaseURL(request), parameters);
        log.debug((Object)("Handler match/Non target application URI => Application redirected: target URL: " + redirectURI));
        response.sendRedirect(redirectURI);
    }

    private void doNoRedirect(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
    }

    private boolean isRequestIntoApplication(HttpServletRequest req, String targetApplicationBaseURL) {
        String uri = req.getRequestURI();
        log.debug((Object)("Request url: " + uri + " and targetApplicationURI: "));
        if (!uri.startsWith(targetApplicationBaseURL)) {
            log.debug((Object)"Request uri is not a child of application base url");
            return false;
        }
        if (uri.equals(targetApplicationBaseURL)) {
            log.debug((Object)"Request uri is the root of the application");
            return true;
        }
        char character = uri.charAt(targetApplicationBaseURL.length());
        if (character != '/' && character != '?' && character != '#' && character != '@') {
            log.debug((Object)"Request uri is not a child of application base url");
            return false;
        }
        log.debug((Object)"Request uri is a child of application base url");
        return true;
    }

    public void destroy() {
        log.debug((Object)"Filter detroyed");
    }
}

