/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.webengine;

import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="WebMobileAuthentication")
@Produces(value={"text/html;charset=UTF-8"})
public class WebMobileAuthentication
extends DefaultObject {
    private static final Log log = LogFactory.getLog(WebMobileAuthentication.class);
    private PluggableAuthenticationService service;
    private String nuxeoContextPath;

    @GET
    @Path(value="login")
    public Object doLogin() {
        return this.getView("login-mobile");
    }

    @GET
    @Path(value="logout")
    public Object doLogout(@Context HttpServletResponse response, @Context HttpServletRequest request) throws Exception {
        Cookie cookie = new Cookie("JSESSIONID", null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        response.addCookie(cookie);
        this.getService().invalidateSession((ServletRequest)request);
        return this.redirect(this.getNuxeoContextPath());
    }

    private String getNuxeoContextPath() {
        if (this.nuxeoContextPath == null) {
            this.nuxeoContextPath = Framework.getProperty((String)"org.nuxeo.ecm.contextPath");
        }
        return this.nuxeoContextPath;
    }

    private PluggableAuthenticationService getService() throws Exception {
        if (this.service == null && Framework.getRuntime() != null) {
            this.service = (PluggableAuthenticationService)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService");
            this.service.initPreFilters();
            if (this.service == null) {
                log.error((Object)"Unable to get Service org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService");
                throw new Exception("Can't initialize Nuxeo Pluggable Authentication Service");
            }
        }
        return this.service;
    }
}

