/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.webengine;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.mobile.webengine.RedirectHelper;
import org.nuxeo.ecm.mobile.webengine.adapter.DefaultMobileAdapter;
import org.nuxeo.ecm.mobile.webengine.document.MobileDocument;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="mobile")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="MobileApplication")
public class MobileApplication
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(MobileApplication.class);
    private UserWorkspaceService userWorkspaceService;
    protected static final Pattern CORDOVA_USER_AGENT_REGEXP = Pattern.compile("Cordova/(.+?) \\((.*)\\)");

    protected void initialize(Object ... args) {
        HashMap<String, String> context = null;
        String userAgent = this.getContext().getRequest().getHeader("User-Agent");
        if (StringUtils.isEmpty((String)userAgent)) {
            log.debug((Object)"User-Agent empty: assuming not on a mobile device.");
            return;
        }
        Matcher matcher = CORDOVA_USER_AGENT_REGEXP.matcher(userAgent);
        if (matcher.find()) {
            context = new HashMap<String, String>();
            context.put("version", matcher.group(1));
            context.put("device", matcher.group(2));
            log.info((Object)"Cordova User-Agent detected");
        }
        this.getContext().setProperty("Cordova", context);
    }

    @GET
    public Object doGet(@QueryParam(value="targetURL") String targetURL) throws Exception {
        DocumentRef targetRef = RedirectHelper.findDocumentRef(targetURL);
        if (targetRef != null) {
            this.setCurrentPage(ToolbarPage.BROWSE);
            MobileDocument targetDoc = new MobileDocument(this.ctx, targetRef);
            return targetDoc.doGet();
        }
        if (this.getSocialObject() != null) {
            return this.redirect(this.ctx.getServerURL() + this.ctx.getModulePath() + "/social");
        }
        HashMap<String, DocumentModelList> args = new HashMap<String, DocumentModelList>();
        args.put("userWorkspace", this.getUserWorkspacesDocs());
        this.setCurrentPage(ToolbarPage.HOME);
        return this.getView("index").args(args);
    }

    @Path(value="auth")
    public Object doTraverseAuthentication() {
        return this.ctx.newObject("WebMobileAuthentication", new Object[0]);
    }

    @Path(value="profile")
    public Object doTraverseProfile() {
        this.setCurrentPage(ToolbarPage.PROFILE);
        return this.ctx.newObject("Profile", new Object[0]);
    }

    @GET
    @Path(value="root")
    public Object getRootRepositoryView() throws Exception {
        DocumentModelList children;
        HashMap<String, DocumentModelList> args = new HashMap<String, DocumentModelList>();
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel doc = session.getRootDocument();
        do {
            if ((children = session.getChildren(doc.getRef(), null, DefaultMobileAdapter.ONLY_VISIBLE_CHILDREN, null)).size() != 1) continue;
            doc = (DocumentModel)children.get(0);
        } while (children.size() == 1);
        args.put("domain", children);
        this.setCurrentPage(ToolbarPage.BROWSE);
        return this.getView("root").args(args);
    }

    @Path(value="docPath/@{adapter}")
    public Object doTraverseRootDocumentByPath(@PathParam(value="adapter") String adapter) {
        PathRef ref = new PathRef("/");
        this.setCurrentPage(ToolbarPage.BROWSE);
        if ("search".equals(adapter)) {
            return new MobileDocument(this.ctx, (DocumentRef)ref).search();
        }
        return new MobileDocument(this.ctx, (DocumentRef)ref).disptachAdapter(adapter);
    }

    @Path(value="docPath{docPathValue:(/(?:(?!/@).)*)}")
    public Object doTraverseDocumentByPath(@PathParam(value="docPathValue") String docPath) {
        PathRef ref = new PathRef(docPath);
        this.setCurrentPage(ToolbarPage.BROWSE);
        return new MobileDocument(this.ctx, (DocumentRef)ref);
    }

    @Path(value="doc/{docId}")
    public Object doTraverseDocument(@PathParam(value="docId") String docId) {
        IdRef ref = new IdRef(docId);
        this.setCurrentPage(ToolbarPage.BROWSE);
        return new MobileDocument(this.ctx, (DocumentRef)ref);
    }

    @Path(value="search")
    public Object doTraverseSearch() {
        this.setCurrentPage(ToolbarPage.SEARCH);
        return this.ctx.newObject("Search", new Object[0]);
    }

    @Path(value="task")
    @Deprecated
    public Object doTraverseTask() {
        return null;
    }

    @Path(value="activity")
    public Object doTraverseActivity() {
        return this.ctx.newObject("Activity", new Object[0]);
    }

    @Path(value="social")
    public Object doSocial() {
        this.setCurrentPage(ToolbarPage.HOME);
        return this.ctx.newObject("Social", new Object[0]);
    }

    protected void setCurrentPage(ToolbarPage page) {
        this.getContext().setProperty("currentPage", (Object)page.name());
    }

    protected DocumentModelList getUserWorkspacesDocs() throws ClientException {
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel userWorkspace = this.getUserWorkspaceService().getCurrentUserPersonalWorkspace(session, null);
        return session.getChildren(userWorkspace.getRef(), null, DefaultMobileAdapter.ONLY_VISIBLE_CHILDREN, null);
    }

    protected Object getSocialObject() {
        try {
            return this.ctx.newObject("Social", new Object[0]);
        }
        catch (Exception e) {
            log.debug((Object)e, (Throwable)e);
            return null;
        }
    }

    protected UserWorkspaceService getUserWorkspaceService() {
        if (this.userWorkspaceService == null) {
            this.userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        }
        return this.userWorkspaceService;
    }

    public String getNuxeoContextPath() {
        return VirtualHostHelper.getBaseURL((ServletRequest)this.request);
    }

    public String getDocumentMobileUrl(DocumentModel doc) {
        String baseUrl = String.format("%s/doc/%s", this.getPath(), doc.getId());
        if (doc.isFolder()) {
            baseUrl = String.format("%s/@folderish", baseUrl);
        }
        return baseUrl;
    }

    protected static enum ToolbarPage {
        HOME,
        BROWSE,
        PROFILE,
        SEARCH;

    }
}

