/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.webengine;

import java.util.HashMap;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.platform.faceted.search.api.service.FacetedSearchService;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Template;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="Search")
@Produces(value={"text/html;charset=UTF-8"})
public class Search
extends DefaultObject {
    private static final Log log = LogFactory.getLog(Search.class);
    private static final String QUERY_PATTERN = "SELECT ecm:uuid, dc:title, dc:description, common:icon FROM Document WHERE ecm:fulltext = '%s' AND (ecm:isCheckedInVersion = 0) AND (ecm:mixinType != 'HiddenInNavigation') AND (ecm:currentLifeCycleState != 'deleted') %s";
    private static final String ORDER_PATTERN = "ORDER BY %s";
    private FacetedSearchService facetedSearchService;

    @GET
    public Template doGet(@QueryParam(value="q") String fulltext, @QueryParam(value="order") String orderParam, @QueryParam(value="max") Integer max) {
        String order = orderParam != null && !"".equals(orderParam.trim()) ? String.format(ORDER_PATTERN, orderParam) : "";
        String query = String.format(QUERY_PATTERN, fulltext, order);
        return this.doGetNXQL(query, max).arg("fulltext", (Object)fulltext);
    }

    @GET
    @Path(value="nxql")
    public Template doGetNXQL(@QueryParam(value="q") String queryString, @QueryParam(value="max") Integer max) {
        IterableQueryResult docs;
        CoreSession session = this.ctx.getCoreSession();
        if (max == null) {
            max = 20;
        }
        try {
            docs = session.queryAndFetch(queryString, "NXQL", new Object[0]);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
            throw new WebException(e.getMessage());
        }
        return this.getView("index").arg("docs", (Object)docs.iterator()).arg("size", (Object)docs.size()).arg("max", (Object)max).arg("q", (Object)queryString);
    }

    @GET
    @Path(value="faceted")
    public Object doGetFacetedSearches() throws ClientException {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("mySearches", this.mySearch());
        args.put("sharedSearches", this.sharedSearches());
        return this.getView("faceted-searches").args(args);
    }

    private List<DocumentModel> mySearch() throws ClientException {
        CoreSession session = this.ctx.getCoreSession();
        List searches = this.getFacetedSearchService().getCurrentUserSavedSearches(session);
        return searches;
    }

    private Object sharedSearches() throws ClientException {
        CoreSession session = this.ctx.getCoreSession();
        List searches = this.getFacetedSearchService().getOtherUsersSavedSearches(session);
        return searches;
    }

    private FacetedSearchService getFacetedSearchService() throws ClientException {
        if (this.facetedSearchService == null) {
            try {
                this.facetedSearchService = (FacetedSearchService)Framework.getService(FacetedSearchService.class);
            }
            catch (Exception e) {
                String errMsg = "Error connecting to FacetedSearchService. " + e.getMessage();
                throw new ClientException(errMsg, (Throwable)e);
            }
            if (this.facetedSearchService == null) {
                throw new ClientException("FacetedSearchService service not bound");
            }
        }
        return this.facetedSearchService;
    }
}

