/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.atompub.AbstractAtomPubServiceCall;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntryParser;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStreamFactory;

public class VersioningService {

    public static class DeleteAllVersions
    extends AbstractAtomPubServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            String objectId = this.getStringParameter(request, "id");
            service.deleteObjectOrCancelCheckOut(repositoryId, objectId, Boolean.TRUE, null);
            response.setStatus(204);
        }
    }

    public static class GetAllVersions
    extends AbstractAtomPubServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            Boolean includeAllowableActions;
            String filter;
            String versionSeriesId;
            String objectId = this.getStringParameter(request, "id");
            List versions = service.getAllVersions(repositoryId, objectId, versionSeriesId = this.getStringParameter(request, "versionSeries"), filter = this.getStringParameter(request, "filter"), includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions"), null);
            if (versions == null || versions.isEmpty()) {
                throw new CmisRuntimeException("Version list is null or empty!");
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=feed");
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            ObjectInfo latestObjectInfo = service.getObjectInfo(repositoryId, ((ObjectData)versions.get(0)).getId());
            ObjectInfo firstObjectInfo = service.getObjectInfo(repositoryId, ((ObjectData)versions.get(versions.size() - 1)).getId());
            feed.writeFeedElements(versionSeriesId, null, firstObjectInfo.getCreatedBy(), latestObjectInfo.getName(), latestObjectInfo.getLastModificationDate(), null, null);
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            if (objectId != null) {
                feed.writeViaLink(this.compileUrl(baseUrl, "entry", objectId));
            }
            AtomEntry entry = new AtomEntry(feed.getWriter());
            for (ObjectData object : versions) {
                if (object == null) continue;
                this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, false, context.getCmisVersion());
            }
            feed.endFeed();
            feed.endDocument();
        }
    }

    public static class CheckOut
    extends AbstractAtomPubServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            ThresholdOutputStreamFactory streamFactory = (ThresholdOutputStreamFactory)context.get("streamFactory");
            AtomEntryParser parser = new AtomEntryParser(streamFactory);
            parser.setIgnoreAtomContentSrc(true);
            parser.parse((InputStream)request.getInputStream());
            Holder checkOutId = new Holder((Object)parser.getId());
            service.checkOut(repositoryId, checkOutId, null, null);
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, (String)checkOutId.getValue());
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            ObjectData object = objectInfo.getObject();
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            if (object.getId() == null) {
                throw new CmisRuntimeException("Object Id is null!");
            }
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            String location = this.compileUrl(baseUrl, "entry", object.getId());
            response.setStatus(201);
            response.setContentType("application/atom+xml;type=entry");
            response.setHeader("Content-Location", location);
            response.setHeader("Location", location);
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true, context.getCmisVersion());
            entry.endDocument();
        }
    }
}

