/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import com.sun.xml.ws.api.WSFeatureList;
import com.sun.xml.ws.developer.StreamingAttachmentFeature;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.WSServlet;
import com.sun.xml.ws.transport.http.servlet.WSServletDelegate;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceFeature;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.server.impl.webservices.ProtectionRequestWrapper;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisWebServicesServlet
extends WSServlet {
    public static final String PARAM_CMIS_VERSION = "cmisVersion";
    public static final String CMIS_VERSION = "org.apache.chemistry.opencmis.cmisVersion";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)CmisWebServicesServlet.class.getName());
    private static final int MAX_SOAP_SIZE = 0xA00000;
    private static final String CMIS10_PATH = "/WEB-INF/cmis10/";
    private static final String CMIS11_PATH = "/WEB-INF/cmis11/";
    private static final Pattern BASE_PATTERN = Pattern.compile("<%cmisbase%>");
    private static final Pattern CORE_PATTERN = Pattern.compile("<%cmiscore%>");
    private static final Pattern MSG_PATTERN = Pattern.compile("<%cmismsg%>");
    private CmisVersion cmisVersion;
    private Map<String, String> docs;

    public void init(ServletConfig config) throws ServletException {
        String cmisVersionStr = config.getInitParameter(PARAM_CMIS_VERSION);
        if (cmisVersionStr != null) {
            try {
                this.cmisVersion = CmisVersion.fromValue((String)cmisVersionStr);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("CMIS version is invalid! Setting it to CMIS 1.0.");
                this.cmisVersion = CmisVersion.CMIS_1_0;
            }
        } else {
            LOG.warn("CMIS version is not defined! Setting it to CMIS 1.0.");
            this.cmisVersion = CmisVersion.CMIS_1_0;
        }
        this.docs = new HashMap<String, String>();
        String path = this.cmisVersion == CmisVersion.CMIS_1_0 ? CMIS10_PATH : CMIS11_PATH;
        this.docs.put("wsdl", this.readFile(config, path + "CMISWS-Service.wsdl.template"));
        this.docs.put("core", this.readFile(config, path + "CMIS-Core.xsd.template"));
        this.docs.put("msg", this.readFile(config, path + "CMIS-Messaging.xsd.template"));
        super.init(config);
    }

    private String readFile(ServletConfig config, String path) throws ServletException {
        String string;
        InputStream stream = config.getServletContext().getResourceAsStream(path);
        if (stream == null) {
            throw new ServletException("Cannot find file '" + path + "'!");
        }
        StringBuilder result = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            string = result.toString();
        }
        catch (IOException e) {
            try {
                throw new ServletException("Cannot read file '" + path + "': " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)reader);
        return string;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute(CMIS_VERSION, (Object)this.cmisVersion);
        if (request.getMethod().equals("GET")) {
            String doc;
            UrlBuilder baseUrl = this.compileBaseUrl(request, response);
            String queryString = request.getQueryString();
            if (queryString != null && (doc = this.docs.get(queryString.toLowerCase(Locale.ENGLISH))) != null) {
                this.printXml(request, response, doc, baseUrl);
                return;
            }
            this.printPage(request, response, baseUrl);
            return;
        }
        if (!request.getMethod().equals("POST")) {
            this.printError(request, response, "Not a HTTP POST request.");
            return;
        }
        ProtectionRequestWrapper requestWrapper = null;
        try {
            requestWrapper = new ProtectionRequestWrapper(request, 0xA00000);
        }
        catch (ServletException e) {
            this.printError(request, response, "The request is not MTOM encoded.");
            return;
        }
        super.service((HttpServletRequest)requestWrapper, response);
    }

    private void printXml(HttpServletRequest request, HttpServletResponse response, String doc, UrlBuilder baseUrl) throws ServletException, IOException {
        response.setStatus(200);
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        String respDoc = doc;
        respDoc = BASE_PATTERN.matcher(respDoc).replaceAll(baseUrl.toString());
        respDoc = CORE_PATTERN.matcher(respDoc).replaceAll(new UrlBuilder(baseUrl).addPath("cmis").addParameter("core").toString());
        respDoc = MSG_PATTERN.matcher(respDoc).replaceAll(new UrlBuilder(baseUrl).addPath("cmis").addParameter("msg").toString());
        PrintWriter pw = response.getWriter();
        pw.print(respDoc);
        pw.flush();
    }

    private void printPage(HttpServletRequest request, HttpServletResponse response, UrlBuilder baseUrl) throws ServletException, IOException {
        response.setStatus(200);
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        String urlEscaped = StringEscapeUtils.escapeHtml((String)new UrlBuilder(baseUrl).addPath("cmis").addParameter("wsdl").toString());
        PrintWriter pw = response.getWriter();
        pw.print("<html><head><title>Apache Chemistry OpenCMIS - CMIS " + this.cmisVersion.value() + " Web Services</title>" + "<style><!--H1 {font-size:24px;line-height:normal;font-weight:bold;background-color:#f0f0f0;color:#003366;border-bottom:1px solid #3c78b5;padding:2px;} " + "BODY {font-family:Verdana,arial,sans-serif;color:black;font-size:14px;} " + "HR {color:#3c78b5;height:1px;}--></style></head><body>");
        pw.print("<h1>CMIS " + this.cmisVersion.value() + " Web Services</h1>");
        pw.print("<p>CMIS WSDL for all services: <a href=\"" + urlEscaped + "\">" + urlEscaped + "</a></p>");
        pw.print("</html></body>");
        pw.flush();
    }

    private void printError(HttpServletRequest request, HttpServletResponse response, String message) throws ServletException, IOException {
        response.setStatus(500);
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        PrintWriter pw = response.getWriter();
        String messageEscaped = StringEscapeUtils.escapeXml((String)message);
        pw.println("<?xml version='1.0' encoding='UTF-8'?>");
        pw.println("<S:Envelope xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        pw.println("<S:Body>");
        pw.println("<S:Fault>");
        pw.println("<faultcode>S:Client</faultcode>");
        pw.println("<faultstring>" + messageEscaped + "</faultstring>");
        pw.println("<detail>");
        pw.println("<cmisFault xmlns=\"http://docs.oasis-open.org/ns/cmis/messaging/200908/\">");
        pw.println("<type>runtime</type>");
        pw.println("<code>0</code>");
        pw.println("<message>" + messageEscaped + "</message>");
        pw.println("</cmisFault>");
        pw.println("</detail>");
        pw.println("</S:Fault>");
        pw.println("</S:Body>");
        pw.println("</S:Envelope>");
        pw.flush();
    }

    private UrlBuilder compileBaseUrl(HttpServletRequest request, HttpServletResponse response) {
        UrlBuilder result;
        String baseUrl = (String)request.getAttribute("org.apache.chemistry.opencmis.baseurl");
        if (baseUrl != null) {
            result = new UrlBuilder(baseUrl);
        } else {
            result = new UrlBuilder(request.getScheme(), request.getServerName(), request.getServerPort(), null);
            result.addPath(request.getContextPath());
            result.addPath(request.getServletPath());
        }
        return result;
    }

    protected WSServletDelegate getDelegate(ServletConfig servletConfig) {
        WSServletDelegate delegate = super.getDelegate(servletConfig);
        if (delegate.adapters != null) {
            CmisServiceFactory factory = (CmisServiceFactory)this.getServletContext().getAttribute("org.apache.chemistry.opencmis.servicesfactory");
            if (factory == null) {
                throw new CmisRuntimeException("Service factory not available! Configuration problem?");
            }
            for (ServletAdapter adapter : delegate.adapters) {
                WSFeatureList wsfl = adapter.getEndpoint().getBinding().getFeatures();
                for (WebServiceFeature ft : wsfl) {
                    if (!(ft instanceof StreamingAttachmentFeature)) continue;
                    ((StreamingAttachmentFeature)ft).setDir(factory.getTempDirectory().getAbsolutePath());
                    this.setMemoryThreshold(factory, (StreamingAttachmentFeature)ft);
                }
            }
        }
        return delegate;
    }

    private void setMemoryThreshold(CmisServiceFactory factory, StreamingAttachmentFeature ft) {
        try {
            ft.setMemoryThreshold(factory.getMemoryThreshold());
        }
        catch (NoSuchMethodError e) {
            try {
                Method m = ft.getClass().getMethod("setMemoryThreshold", Long.TYPE);
                m.invoke((Object)ft, factory.getMemoryThreshold());
            }
            catch (Exception e2) {
                LOG.warn("Could not set memory threshold for streaming");
            }
        }
    }
}

