/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;
import java.sql.DriverManager;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class JreMemoryLeakPreventionListener
implements LifecycleListener {
    private static final Log log;
    private static final StringManager sm;
    private static final boolean IS_JAVA_7_OR_LATER;
    private boolean appContextProtection = !IS_JAVA_7_OR_LATER;
    private boolean awtThreadProtection = false;
    private boolean java2dDisposerProtection = false;
    private boolean gcDaemonProtection = true;
    private boolean securityPolicyProtection = true;
    private boolean securityLoginConfigurationProtection = true;
    private boolean tokenPollerProtection = true;
    private boolean urlCacheProtection = true;
    private boolean xmlParsingProtection = true;
    private boolean ldapPoolProtection = true;
    private boolean driverManagerProtection = true;
    private String classesToInitialize = null;

    public boolean isAppContextProtection() {
        return this.appContextProtection;
    }

    public void setAppContextProtection(boolean appContextProtection) {
        this.appContextProtection = appContextProtection;
    }

    public boolean isAWTThreadProtection() {
        return this.awtThreadProtection;
    }

    public void setAWTThreadProtection(boolean awtThreadProtection) {
        this.awtThreadProtection = awtThreadProtection;
    }

    public boolean isJava2DDisposerProtection() {
        return this.java2dDisposerProtection;
    }

    public void setJava2DDisposerProtection(boolean java2dDisposerProtection) {
        this.java2dDisposerProtection = java2dDisposerProtection;
    }

    public boolean isGcDaemonProtection() {
        return this.gcDaemonProtection;
    }

    public void setGcDaemonProtection(boolean gcDaemonProtection) {
        this.gcDaemonProtection = gcDaemonProtection;
    }

    public boolean isSecurityPolicyProtection() {
        return this.securityPolicyProtection;
    }

    public void setSecurityPolicyProtection(boolean securityPolicyProtection) {
        this.securityPolicyProtection = securityPolicyProtection;
    }

    public boolean isSecurityLoginConfigurationProtection() {
        return this.securityLoginConfigurationProtection;
    }

    public void setSecurityLoginConfigurationProtection(boolean securityLoginConfigurationProtection) {
        this.securityLoginConfigurationProtection = securityLoginConfigurationProtection;
    }

    public boolean isTokenPollerProtection() {
        return this.tokenPollerProtection;
    }

    public void setTokenPollerProtection(boolean tokenPollerProtection) {
        this.tokenPollerProtection = tokenPollerProtection;
    }

    public boolean isUrlCacheProtection() {
        return this.urlCacheProtection;
    }

    public void setUrlCacheProtection(boolean urlCacheProtection) {
        this.urlCacheProtection = urlCacheProtection;
    }

    public boolean isXmlParsingProtection() {
        return this.xmlParsingProtection;
    }

    public void setXmlParsingProtection(boolean xmlParsingProtection) {
        this.xmlParsingProtection = xmlParsingProtection;
    }

    public boolean isLdapPoolProtection() {
        return this.ldapPoolProtection;
    }

    public void setLdapPoolProtection(boolean ldapPoolProtection) {
        this.ldapPoolProtection = ldapPoolProtection;
    }

    public boolean isDriverManagerProtection() {
        return this.driverManagerProtection;
    }

    public void setDriverManagerProtection(boolean driverManagerProtection) {
        this.driverManagerProtection = driverManagerProtection;
    }

    public String getClassesToInitialize() {
        return this.classesToInitialize;
    }

    public void setClassesToInitialize(String classesToInitialize) {
        this.classesToInitialize = classesToInitialize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_init".equals(event.getType())) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Method method;
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                if (this.driverManagerProtection) {
                    DriverManager.getDrivers();
                }
                if (this.appContextProtection) {
                    ImageIO.getCacheDirectory();
                }
                if (this.awtThreadProtection) {
                    Toolkit.getDefaultToolkit();
                }
                if (this.java2dDisposerProtection) {
                    try {
                        Class.forName("sun.java2d.Disposer");
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
                if (this.gcDaemonProtection) {
                    try {
                        Class<?> clazz = Class.forName("sun.misc.GC");
                        method = clazz.getDeclaredMethod("requestLatency", Long.TYPE);
                        method.invoke(null, 0x7FFFFFFFFFFFFFFEL);
                    }
                    catch (ClassNotFoundException e) {
                        if (System.getProperty("java.vendor").startsWith("Sun")) {
                            log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                        } else {
                            log.debug((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                        }
                    }
                    catch (SecurityException e) {
                        log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        ExceptionUtils.handleThrowable((Throwable)e.getCause());
                        log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                    }
                }
                if (this.securityPolicyProtection) {
                    try {
                        Class<?> policyClass = Class.forName("javax.security.auth.Policy");
                        method = policyClass.getMethod("getPolicy", new Class[0]);
                        method.invoke(null, new Object[0]);
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (SecurityException e) {
                    }
                    catch (NoSuchMethodException e) {
                        log.warn((Object)sm.getString("jreLeakListener.authPolicyFail"), (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        log.warn((Object)sm.getString("jreLeakListener.authPolicyFail"), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        log.warn((Object)sm.getString("jreLeakListener.authPolicyFail"), (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        ExceptionUtils.handleThrowable((Throwable)e.getCause());
                        log.warn((Object)sm.getString("jreLeakListener.authPolicyFail"), (Throwable)e);
                    }
                }
                if (this.securityLoginConfigurationProtection) {
                    try {
                        Class.forName("javax.security.auth.login.Configuration", true, ClassLoader.getSystemClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (this.tokenPollerProtection) {
                    Security.getProviders();
                }
                if (this.urlCacheProtection) {
                    try {
                        URL url = new URL("jar:file://dummy.jar!/");
                        URLConnection uConn = url.openConnection();
                        uConn.setDefaultUseCaches(false);
                    }
                    catch (MalformedURLException e) {
                        log.error((Object)sm.getString("jreLeakListener.jarUrlConnCacheFail"), (Throwable)e);
                    }
                    catch (IOException e) {
                        log.error((Object)sm.getString("jreLeakListener.jarUrlConnCacheFail"), (Throwable)e);
                    }
                }
                if (this.xmlParsingProtection) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    try {
                        factory.newDocumentBuilder();
                    }
                    catch (ParserConfigurationException e) {
                        log.error((Object)sm.getString("jreLeakListener.xmlParseFail"), (Throwable)e);
                    }
                }
                if (this.ldapPoolProtection) {
                    try {
                        Class.forName("com.sun.jndi.ldap.LdapPoolManager");
                    }
                    catch (ClassNotFoundException e) {
                        if (System.getProperty("java.vendor").startsWith("Sun")) {
                            log.error((Object)sm.getString("jreLeakListener.ldapPoolManagerFail"), (Throwable)e);
                        }
                        log.debug((Object)sm.getString("jreLeakListener.ldapPoolManagerFail"), (Throwable)e);
                    }
                }
                if (this.classesToInitialize != null) {
                    StringTokenizer strTok = new StringTokenizer(this.classesToInitialize, ", \r\n\t");
                    while (strTok.hasMoreTokens()) {
                        String classNameToLoad = strTok.nextToken();
                        try {
                            Class.forName(classNameToLoad);
                        }
                        catch (ClassNotFoundException e) {
                            log.error((Object)sm.getString("jreLeakListener.classToInitializeFail", new Object[]{classNameToLoad}), (Throwable)e);
                        }
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
    }

    static {
        boolean isJava7OrLater;
        log = LogFactory.getLog(JreMemoryLeakPreventionListener.class);
        sm = StringManager.getManager((String)"org.apache.catalina.core");
        try {
            Class.forName("java.util.Objects");
            isJava7OrLater = true;
        }
        catch (ClassNotFoundException e) {
            isJava7OrLater = false;
        }
        IS_JAVA_7_OR_LATER = isJava7OrLater;
    }
}

