/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.webengine.sc;

import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.mobile.webengine.adapter.DefaultMobileAdapter;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.rating.api.RatingService;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="Social")
@Produces(value={"text/html;charset=UTF-8"})
public class SocialObject
extends DefaultObject {
    private static final Log log = LogFactory.getLog(SocialObject.class);
    protected UserWorkspaceService userWorkspaceService;

    protected void initialize(Object ... args) {
        super.initialize(args);
    }

    @GET
    public Object doGet() throws ClientException {
        HashMap<String, DocumentModelList> args = new HashMap<String, DocumentModelList>();
        args.put("latestLiked", this.getLatestRatedDocs());
        args.put("userWorkspace", this.getUserWorkspacesDocs());
        return this.getView("index").args(args);
    }

    protected DocumentModelList getUserWorkspacesDocs() throws ClientException {
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel userWorkspace = this.getUserWorkspaceService().getCurrentUserPersonalWorkspace(session, null);
        return session.getChildren(userWorkspace.getRef(), null, DefaultMobileAdapter.ONLY_VISIBLE_CHILDREN, null);
    }

    protected UserWorkspaceService getUserWorkspaceService() {
        if (this.userWorkspaceService == null) {
            this.userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        }
        return this.userWorkspaceService;
    }

    protected DocumentModelList getLatestRatedDocs() {
        ActivitiesList latestAct = this.getRatingService().getLastestRatedDocByUser(this.ctx.getPrincipal().getName(), "like", 10);
        latestAct.filterActivities(this.ctx.getCoreSession());
        DocumentModelListImpl ret = new DocumentModelListImpl();
        for (Activity activity : latestAct) {
            try {
                IdRef ref = new IdRef(ActivityHelper.getDocumentId((String)activity.getTarget()));
                ret.add((Object)this.ctx.getCoreSession().getDocument((DocumentRef)ref));
            }
            catch (ClientException e) {
                log.info((Object)e.getMessage());
                log.debug((Object)e, (Throwable)e);
            }
        }
        return ret;
    }

    protected RatingService getRatingService() {
        return (RatingService)Framework.getLocalService(RatingService.class);
    }
}

