/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.webengine.adapter;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.mobile.webengine.adapter.DefaultMobileAdapter;
import org.nuxeo.ecm.platform.comment.api.CommentableDocument;
import org.nuxeo.ecm.webengine.model.WebAdapter;

@WebAdapter(name="comment", type="Comment", targetType="MobileDocument")
public class CommentAdapter
extends DefaultMobileAdapter {
    private CommentableDocument commentableDocument;

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    @POST
    public Object doPost(@FormParam(value="newComment") String newTextComment) throws PropertyException, ClientException {
        DocumentModel comment = this.initializeEmptyComment();
        comment.setPropertyValue("comment:text", (Serializable)((Object)newTextComment));
        this.getCommentableDocument().addComment(comment);
        this.ctx.getCoreSession().saveDocument(this.getDocumentModel());
        return this.getView("index");
    }

    @POST
    @Path(value="{commentIdParent}")
    public Object doPostReplyForm(@FormParam(value="newComment") String newTextComment, @PathParam(value="commentIdParent") String commentIdParent) throws PropertyException, ClientException {
        DocumentModel commentParent = null;
        if (commentIdParent != null && !"null".equals(commentIdParent)) {
            commentParent = this.ctx.getCoreSession().getDocument((DocumentRef)new IdRef(commentIdParent));
        }
        DocumentModel comment = this.initializeEmptyComment();
        comment.setPropertyValue("comment:text", (Serializable)((Object)newTextComment));
        if (commentParent != null) {
            this.getCommentableDocument().addComment(commentParent, comment);
        } else {
            this.getCommentableDocument().addComment(comment);
        }
        this.ctx.getCoreSession().saveDocument(this.getDocumentModel());
        return this.redirect(this.getPath());
    }

    @GET
    @Path(value="{commentIdParent}")
    public Object doGetReplyForm(@PathParam(value="commentIdParent") String commentIdParent) throws PropertyException, ClientException {
        return this.getView("new").arg("parentId", (Object)commentIdParent);
    }

    @GET
    @Path(value="{commentId}/@delete")
    public Object doDeleteComment(@PathParam(value="commentId") String commentId) throws PropertyException, ClientException {
        this.ctx.getCoreSession().removeDocument((DocumentRef)new IdRef(commentId));
        return Response.ok().build();
    }

    public List<DocumentModel> getComments() throws ClientException {
        List comments = this.getCommentableDocument().getComments();
        return comments;
    }

    public List<DocumentModel> getComments(DocumentModel commentParent) throws ClientException {
        List comments = this.getCommentableDocument().getComments(commentParent);
        return comments;
    }

    public boolean hasWriteRightOnComment(DocumentModel comment) throws ClientException {
        return this.ctx.getCoreSession().hasPermission(comment.getRef(), "Write");
    }

    private CommentableDocument getCommentableDocument() {
        if (this.commentableDocument == null) {
            this.commentableDocument = (CommentableDocument)this.getDocumentModel().getAdapter(CommentableDocument.class);
        }
        return this.commentableDocument;
    }

    public boolean hasAddingCommentRight() throws ClientException {
        return this.ctx.getCoreSession().hasPermission(this.getDocumentModel().getRef(), "Write");
    }

    protected DocumentModel initializeEmptyComment() throws ClientException {
        DocumentModel comment = this.ctx.getCoreSession().createDocumentModel("Comment");
        String[] contributors = new String[]{this.ctx.getPrincipal().getName()};
        comment.setProperty("dublincore", "contributors", (Object)contributors);
        comment.setProperty("dublincore", "created", (Object)Calendar.getInstance());
        comment.setProperty("comment", "author", (Object)this.ctx.getPrincipal().getName());
        comment.setProperty("comment", "creationDate", (Object)Calendar.getInstance());
        return comment;
    }
}

