/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.mobile.ApplicationDefinitionDescriptor;
import org.nuxeo.ecm.mobile.ApplicationDefinitionService;
import org.nuxeo.ecm.mobile.MobileApplicationComparator;
import org.nuxeo.ecm.mobile.RequestHandlerDescriptor;
import org.nuxeo.ecm.mobile.handler.RequestHandler;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ApplicationRedirectServiceImpl
extends DefaultComponent
implements ApplicationDefinitionService {
    private static final Log log = LogFactory.getLog(ApplicationRedirectServiceImpl.class);
    private final Map<String, ApplicationDefinitionDescriptor> applications = new HashMap<String, ApplicationDefinitionDescriptor>();
    private final Map<String, RequestHandlerDescriptor> requestHandlers = new HashMap<String, RequestHandlerDescriptor>();
    private final List<ApplicationDefinitionDescriptor> applicationsOrdered = new ArrayList<ApplicationDefinitionDescriptor>();
    private List<String> unAuthenticatedURLPrefix;
    private Path nuxeoRelativeContextPath;

    protected String buildRedirectUrl(HttpServletRequest request, String ... uris) {
        Path path = new Path("");
        for (String uri : uris) {
            path = path.append(uri);
        }
        return VirtualHostHelper.getBaseURL((ServletRequest)request) + path.toString();
    }

    protected Path getNuxeoRelativeContextPath() {
        if (this.nuxeoRelativeContextPath == null) {
            this.nuxeoRelativeContextPath = new Path(Framework.getProperty((String)"org.nuxeo.ecm.contextPath"));
        }
        return this.nuxeoRelativeContextPath;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        ExtensionPoint ep = Enum.valueOf(ExtensionPoint.class, extensionPoint);
        switch (ep) {
            case applicationDefinition: {
                this.registerApplication((ApplicationDefinitionDescriptor)contribution, contributor.getName().getName());
                break;
            }
            case requestHandlers: {
                this.registerRequestHandler((RequestHandlerDescriptor)contribution, contributor.getName().getName());
                break;
            }
            default: {
                throw new RuntimeException("error in exception handling configuration");
            }
        }
    }

    protected void registerRequestHandler(RequestHandlerDescriptor rhd, String componentName) {
        RequestHandlerDescriptor finalRH = null;
        String requestHandlerName = rhd.getRequestHandlerName();
        if (this.requestHandlers.containsKey(requestHandlerName)) {
            if (!rhd.disabled) {
                String messageTemplate = "Request Handler definition %s will be overriden by on declared into %s component";
                String message = String.format(messageTemplate, requestHandlerName, componentName);
                log.info((Object)message);
            } else {
                String messageTemplate = "Request Handler definition '%s' will be removed as defined into %s";
                String message = String.format(messageTemplate, requestHandlerName, componentName);
                log.info((Object)message);
                for (ApplicationDefinitionDescriptor app : this.applicationsOrdered) {
                    if (!app.getRequestHandlerName().equals(requestHandlerName)) continue;
                    messageTemplate = "Request Handler definition '%s' used by %s Application Definition";
                    message = String.format(messageTemplate, requestHandlerName, app.getName());
                    log.warn((Object)message);
                }
            }
            finalRH = this.mergeRequestHandlerDescriptor(this.requestHandlers.get(requestHandlerName), rhd);
        } else {
            finalRH = rhd;
        }
        this.requestHandlers.put(requestHandlerName, finalRH);
    }

    private RequestHandlerDescriptor mergeRequestHandlerDescriptor(RequestHandlerDescriptor initial, RequestHandlerDescriptor toMerge) {
        if (toMerge.klass == null) {
            toMerge.klass = initial.klass;
        }
        if (toMerge.properties == null) {
            toMerge.properties = initial.properties;
        }
        return toMerge;
    }

    protected void registerApplication(ApplicationDefinitionDescriptor appDescriptor, String componentName) {
        String message;
        String messageTemplate;
        String name = appDescriptor.getName();
        this.validateApplicationDescriptor(appDescriptor, componentName);
        if (this.applications.containsKey(name)) {
            if (!appDescriptor.isDisable()) {
                messageTemplate = "Application definition '%s' will be overridden, replaced by ones declared into %s component";
                message = String.format(messageTemplate, name, componentName);
                log.info((Object)message);
                this.applicationsOrdered.remove(name);
            } else {
                String messageTemplate2 = "Application definition '%s' will be removed as defined into %s";
                String message2 = String.format(messageTemplate2, name, componentName);
                log.info((Object)message2);
                this.disableApplication(name);
                return;
            }
        }
        if (appDescriptor.isDisable()) {
            messageTemplate = "Application definition '%s' already removed, definition into %s component ignored";
            message = String.format(messageTemplate, name, componentName);
            log.info((Object)message);
            this.disableApplication(name);
            return;
        }
        messageTemplate = "New Application definition detected '%s' into %s component";
        message = String.format(messageTemplate, name, componentName);
        log.info((Object)message);
        this.applications.put(name, appDescriptor);
        this.applicationsOrdered.add(appDescriptor);
        Collections.sort(this.applicationsOrdered, new MobileApplicationComparator());
        this.unAuthenticatedURLPrefix = null;
    }

    private void disableApplication(String applicationName) {
        this.applications.remove(applicationName);
        for (int i = 0; i < this.applicationsOrdered.size(); ++i) {
            ApplicationDefinitionDescriptor application = this.applicationsOrdered.get(i);
            if (!application.getName().equals(applicationName)) continue;
            this.applicationsOrdered.remove(i);
        }
    }

    protected String getBaseURL(HttpServletRequest request) {
        return VirtualHostHelper.getWebAppName((ServletRequest)request);
    }

    protected RequestHandlerDescriptor getRequestHandlerByName(String name) {
        return this.requestHandlers.get(name);
    }

    private ApplicationDefinitionDescriptor getTargetApplication(HttpServletRequest request) {
        for (ApplicationDefinitionDescriptor application : this.applicationsOrdered) {
            RequestHandlerDescriptor rhd = this.getRequestHandlerByName(application.getRequestHandlerName());
            if (rhd == null) {
                String message = "Can't find request handler %s for app definition %s, please check your configuration, skipping check";
                log.error((Object)String.format(message, application.getRequestHandlerName(), application.getName()));
                continue;
            }
            RequestHandler handler = rhd.getRequestHandlerInstance();
            if (!handler.isRequestRedirectedToApplication(request)) continue;
            String messageTemplate = "Request '%s' match the application '%s' request handler";
            String message = String.format(messageTemplate, request.getRequestURI(), application.getName());
            log.debug((Object)message);
            return application;
        }
        log.debug((Object)"Request match no application request handler");
        return null;
    }

    @Override
    public String getApplicationBaseURL(HttpServletRequest request) {
        ApplicationDefinitionDescriptor app = this.getTargetApplication(request);
        if (app == null) {
            log.debug((Object)String.format("No application matched for this request, no Application base url found", new Object[0]));
            return null;
        }
        return this.buildRedirectUrl(request, app.getApplicationRelativePath());
    }

    @Override
    public String getApplicationBaseURI(HttpServletRequest request) {
        ApplicationDefinitionDescriptor app = this.getTargetApplication(request);
        if (app == null) {
            log.debug((Object)String.format("No application matched for this request, no Application base uri found", new Object[0]));
            return null;
        }
        return this.getNuxeoRelativeContextPath().append(app.getApplicationRelativePath()).toString();
    }

    @Override
    public String getLoginURL(HttpServletRequest request) {
        ApplicationDefinitionDescriptor app = this.getTargetApplication(request);
        if (app == null) {
            log.debug((Object)String.format("No application matched for this request, no Login page found", new Object[0]));
            return null;
        }
        return this.buildRedirectUrl(request, app.getApplicationRelativePath(), app.getLoginPage());
    }

    @Override
    public String getLogoutURL(HttpServletRequest request) {
        ApplicationDefinitionDescriptor app = this.getTargetApplication(request);
        if (app == null) {
            log.debug((Object)String.format("No application matched for this request,, no Logout page found", new Object[0]));
            return null;
        }
        return this.buildRedirectUrl(request, app.getApplicationRelativePath(), app.getLogoutPage());
    }

    private void validateApplicationDescriptor(ApplicationDefinitionDescriptor app, String componentName) {
        String message;
        String messageTemplate;
        if (app.getName() == null) {
            String messageTemplate2 = "Application given in '%s' component is null, can't register it";
            String message2 = String.format(messageTemplate2, componentName);
            throw new RuntimeException(message2);
        }
        if (app.getApplicationRelativePath() == null) {
            String messageTemplate3 = "Application name %s given in '%s' component as an empty base URL, can't register it";
            String message3 = String.format(messageTemplate3, app.getName(), componentName);
            throw new RuntimeException(message3);
        }
        if (app.getApplicationRelativePath().startsWith("/")) {
            log.warn((Object)"Application relative path must not start by a slash, please think to change your contribution");
            app.applicationRelativePath = app.getApplicationRelativePath().substring(1);
        }
        if (app.getApplicationRelativePath().endsWith("/")) {
            log.warn((Object)"Application relative path must not end with a slash, please think to change your contribution");
            app.applicationRelativePath = app.getApplicationRelativePath().substring(0, app.getApplicationRelativePath().length() - 1);
        }
        ArrayList<String> resourcesUriChanged = new ArrayList<String>();
        for (String resourceUri : app.getResourcesBaseUrl()) {
            if (resourceUri.startsWith("/")) {
                log.warn((Object)"Resource Uri relative path must not start by a slash, please think to change your contribution");
                resourceUri = resourceUri.substring(1);
            }
            resourcesUriChanged.add(resourceUri);
            app.resourcesBaseUrl = resourcesUriChanged;
        }
        if (app.getLoginPage() == null) {
            messageTemplate = "Application name %s given in '%s' component as an empty login URL, can't register it";
            message = String.format(messageTemplate, app.getName(), componentName);
            throw new RuntimeException(message);
        }
        if (app.getLogoutPage() == null) {
            messageTemplate = "Application name %s given in '%s' component as an empty logout URL, can't register it";
            message = String.format(messageTemplate, app.getName(), componentName);
            throw new RuntimeException(message);
        }
    }

    @Override
    public List<String> getUnAuthenticatedURLPrefix(HttpServletRequest request) {
        ApplicationDefinitionDescriptor app = this.getTargetApplication(request);
        return this.getUnAuthenticatedURLPrefix(app);
    }

    private List<String> getUnAuthenticatedURLPrefix(ApplicationDefinitionDescriptor app) {
        ArrayList<String> result = new ArrayList<String>();
        if (app == null) {
            return null;
        }
        String loginPage = new Path(app.getApplicationRelativePath()).append(app.getLoginPage()).toString();
        log.debug((Object)("Add login page as Unauthenticated resources" + loginPage));
        result.add(loginPage);
        if (app.getResourcesBaseUrl() != null) {
            result.addAll(app.getResourcesBaseUrl());
        } else {
            log.error((Object)("No base URL found can't add unauthenticated URL for application: " + app.getName()));
        }
        return result;
    }

    @Override
    public List<String> getUnAuthenticatedURLPrefix() {
        if (this.unAuthenticatedURLPrefix == null) {
            this.unAuthenticatedURLPrefix = new ArrayList<String>();
            for (ApplicationDefinitionDescriptor app : this.applicationsOrdered) {
                this.unAuthenticatedURLPrefix.addAll(this.getUnAuthenticatedURLPrefix(app));
            }
        }
        return this.unAuthenticatedURLPrefix;
    }

    @Override
    public boolean isResourceURL(HttpServletRequest request) {
        ApplicationDefinitionDescriptor app = this.getTargetApplication(request);
        if (app == null) {
            return false;
        }
        List<String> resourcesBaseURL = app.getResourcesBaseUrl();
        if (resourcesBaseURL == null || resourcesBaseURL.size() == 0) {
            return false;
        }
        String uri = request.getRequestURI();
        for (String resourceBaseURL : resourcesBaseURL) {
            log.debug((Object)("Check if this is this Resources application : " + new Path("/").append(this.getNuxeoRelativeContextPath()).append(resourceBaseURL) + " for uri : " + uri));
            if (!uri.startsWith(new Path("/").append(this.getNuxeoRelativeContextPath()).append(resourceBaseURL).toString())) continue;
            return true;
        }
        return false;
    }

    public static enum ExtensionPoint {
        applicationDefinition,
        requestHandlers;

    }
}

