/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.webengine.adapter;

import java.util.Collections;
import java.util.HashMap;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelComparator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.impl.CompoundFilter;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.impl.LifeCycleFilter;
import org.nuxeo.ecm.mobile.webengine.document.MobileDocument;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;

public abstract class DefaultMobileAdapter
extends DefaultAdapter {
    public static final Filter ONLY_VISIBLE_CHILDREN = new CompoundFilter(new Filter[]{new FacetFilter(null, Collections.singletonList("HiddenInNavigation")), new LifeCycleFilter(null, Collections.singletonList("deleted"))});

    protected DocumentModel getDocumentModel() {
        MobileDocument doc = this.getMobileDocument();
        if (doc == null) {
            doc = this.getMobileDocument();
        }
        return doc.getDocument();
    }

    protected MobileDocument getMobileDocument() {
        Resource targetObject = this.ctx.getTargetObject();
        if (!(targetObject instanceof MobileDocument)) {
            throw new WebException("Target Object must be MobileDocument");
        }
        MobileDocument mobileDoc = (MobileDocument)targetObject;
        return mobileDoc;
    }

    public DocumentModelList getChildren() {
        CoreSession session = this.ctx.getCoreSession();
        HashMap<String, String> order = new HashMap<String, String>();
        order.put("title", "asc");
        DocumentModelComparator dmc = new DocumentModelComparator("dublincore", order);
        return session.getChildren(this.getDocumentModel().getRef(), null, ONLY_VISIBLE_CHILDREN, (Sorter)dmc);
    }
}

