/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.webengine;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.Template;
import org.nuxeo.ecm.webengine.model.TemplateNotFoundException;
import org.nuxeo.ecm.webengine.model.View;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="Profile")
@Produces(value={"text/html;charset=UTF-8"})
public class Profile
extends DefaultObject {
    private static final Log log = LogFactory.getLog(Profile.class);
    private boolean hasBeenFetched;
    private UserProfileService userProfileService;

    @GET
    @Path(value="search")
    public Object doGetUsers(@QueryParam(value="q") String query) {
        DocumentModelList users = this.getUserManager().searchUsers(query);
        return this.getView("users").arg("users", (Object)users);
    }

    @GET
    @Path(value="{username}")
    public Template doGetUser(@PathParam(value="username") String username) {
        DocumentModel userProfile = this.getUserProfile(username);
        DocumentModel userMainInfo = this.getUserManager().getUserModel(username);
        return this.getView("view").arg("userProfile", (Object)userProfile).arg("userMainInfo", (Object)userMainInfo);
    }

    public boolean isRichProfileDeployed() {
        return this.getUserProfileService() != null;
    }

    public String getAvatarURI(String username) {
        Blob avatar;
        String contextPath = Framework.getProperty((String)"org.nuxeo.ecm.contextPath");
        DocumentModel userProfile = this.getUserProfile(username);
        try {
            avatar = (Blob)userProfile.getPropertyValue("userprofile:avatar");
        }
        catch (PropertyException e) {
            log.debug((Object)"No avatar found");
            avatar = null;
        }
        if (userProfile != null && avatar != null) {
            DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
            return contextPath + "/" + downloadService.getDownloadUrl(userProfile, "userprofile:avatar", "");
        }
        return contextPath + "/site/skin/nuxeo/icons/default_avatar.png";
    }

    private DocumentModel getUserProfile(String username) {
        return this.getUserProfileService().getUserProfileDocument(username, this.ctx.getCoreSession());
    }

    private String getViewSuffix() {
        if (this.isRichProfileDeployed()) {
            return "rich";
        }
        return "standard";
    }

    public Template getView(String viewId) {
        String dedicatedViewId = String.format("%s-%s", viewId, this.getViewSuffix());
        try {
            return new View((Resource)this, dedicatedViewId).resolve();
        }
        catch (TemplateNotFoundException e) {
            log.debug((Object)"Dedicated view not exists, try use standard binding");
            return new View((Resource)this, viewId).resolve();
        }
    }

    private UserProfileService getUserProfileService() {
        if (!this.hasBeenFetched) {
            this.hasBeenFetched = false;
            try {
                Class.forName("org.nuxeo.ecm.user.center.profile.UserProfileService");
            }
            catch (ReflectiveOperationException e) {
                log.info((Object)"UserProfileService not deployed, use the UserManager");
                return null;
            }
            this.userProfileService = (UserProfileService)Framework.getService(UserProfileService.class);
        }
        return this.userProfileService;
    }

    private UserManager getUserManager() {
        return (UserManager)Framework.getService(UserManager.class);
    }
}

