/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.filter;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.mobile.ApplicationDefinitionService;
import org.nuxeo.ecm.platform.ui.web.auth.service.OpenUrlDescriptor;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.runtime.api.Framework;

public class RequestAdapter {
    public static final String TARGET_URL_PARAMETER_NAME = "targetURL";
    private static final Log log = LogFactory.getLog(RequestAdapter.class);
    private HttpServletRequest request;
    private PluggableAuthenticationService authenticationService;
    private ApplicationDefinitionService service;

    public RequestAdapter(HttpServletRequest request) {
        this.request = request;
    }

    public boolean isOpenURL() {
        if (this.getAuthenticationService() != null) {
            List openUrls = this.getAuthenticationService().getOpenUrls();
            for (OpenUrlDescriptor openUrl : openUrls) {
                if (!openUrl.allowByPassAuth(this.request)) continue;
                log.debug((Object)("Open URL (defined into the PluggableAuthenticationService) detected: no redirect: final URL: " + this.request.getRequestURI()));
                return true;
            }
            if (this.service == null) {
                this.service = (ApplicationDefinitionService)Framework.getLocalService(ApplicationDefinitionService.class);
            }
            String requestPage = RequestAdapter.getRequestedPage(this.request);
            for (String prefix : this.service.getUnAuthenticatedURLPrefix(this.request)) {
                if (!requestPage.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    protected static String getRequestedPage(HttpServletRequest httpRequest) {
        String requestURI = httpRequest.getRequestURI();
        String context = httpRequest.getContextPath() + '/';
        return requestURI.substring(context.length());
    }

    private String getRequestURIWithParameters() throws UnsupportedEncodingException {
        String queryString = this.request.getQueryString() != null ? "?" + URIUtils.getURIQuery(this.getParameters()) : "";
        return this.request.getRequestURI() + queryString;
    }

    private PluggableAuthenticationService getAuthenticationService() {
        if (this.authenticationService == null) {
            this.authenticationService = (PluggableAuthenticationService)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService");
            if (this.authenticationService == null) {
                throw new RuntimeException("Unable to get Service org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService");
            }
        }
        return this.authenticationService;
    }

    public Map<String, String> getParametersAndAddTargetURLIfNotSet() throws UnsupportedEncodingException {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration paramNames = this.request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            String value = this.request.getParameter(name);
            result.put(name, value);
        }
        HttpSession session = this.request.getSession(false);
        String targetUrl = null;
        if (session != null && !result.containsKey(TARGET_URL_PARAMETER_NAME)) {
            targetUrl = (String)session.getAttribute("Nuxeo5_Start_Page");
            if (targetUrl != null && !"".equals(targetUrl.trim())) {
                log.debug((Object)("Put the target URL into the URL parameter: " + this.request.getRequestURI()));
                result.put(TARGET_URL_PARAMETER_NAME, URLEncoder.encode(targetUrl, "UTF-8"));
            } else {
                result.put(TARGET_URL_PARAMETER_NAME, this.getRequestURIWithParameters());
            }
        }
        return result;
    }

    public String getTargetURLFromParameter() {
        try {
            return this.getParameters().get(TARGET_URL_PARAMETER_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new NuxeoException(e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, String> getParameters() throws UnsupportedEncodingException {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration paramNames = this.request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            String value = this.request.getParameter(name);
            result.put(name, value);
        }
        return result;
    }
}

