/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.webengine.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.mobile.webengine.adapter.DefaultMobileAdapter;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.Subject;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.web.NodeInfo;
import org.nuxeo.ecm.platform.relations.web.NodeInfoImpl;
import org.nuxeo.ecm.platform.relations.web.StatementInfo;
import org.nuxeo.ecm.platform.relations.web.StatementInfoImpl;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="relation", type="Relation", targetType="MobileDocument")
public class RelationAdapter
extends DefaultMobileAdapter {
    public static final String PREDICATES_DIRECTORY = "predicates";

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    public Map<String, List<StatementInfo>> getRelations() {
        DocumentModel doc = this.getDocumentModel();
        RelationManager relationManager = (RelationManager)Framework.getLocalService(RelationManager.class);
        QNameResource docResource = this.getDocumentResource(doc);
        ArrayList<StatementInfo> allStatements = new ArrayList<StatementInfo>();
        if (docResource != null) {
            StatementImpl pattern = new StatementImpl((Node)docResource, null, null);
            List outgoingStatements = relationManager.getStatements("default", (Statement)pattern);
            allStatements.addAll(this.getStatementsInfo(outgoingStatements));
            pattern = new StatementImpl(null, null, (Node)docResource);
            List incomingStatements = relationManager.getStatements("default", (Statement)pattern);
            allStatements.addAll(this.getStatementsInfo(incomingStatements));
        }
        HashMap<String, List<StatementInfo>> relations = new HashMap<String, List<StatementInfo>>();
        for (StatementInfo statement : allStatements) {
            String label = this.getPredicateLabel(PREDICATES_DIRECTORY, statement);
            if (!relations.containsKey(label)) {
                relations.put(label, new ArrayList());
            }
            List statements = (List)relations.get(label);
            statements.add(statement);
            relations.put(label, statements);
        }
        return relations;
    }

    public boolean hasRelation() {
        Map<String, List<StatementInfo>> relation = this.getRelations();
        for (String key : relation.keySet()) {
            if (relation.get(key).size() <= 0) continue;
            return true;
        }
        return false;
    }

    private QNameResource getDocumentResource(DocumentModel document) {
        QNameResource documentResource = null;
        if (document != null) {
            documentResource = (QNameResource)((RelationManager)Framework.getLocalService(RelationManager.class)).getResource("http://www.nuxeo.org/document/uid/", (Serializable)document, null);
        }
        return documentResource;
    }

    private List<StatementInfo> getStatementsInfo(List<Statement> statements) {
        if (statements == null) {
            return null;
        }
        ArrayList<StatementInfo> infoList = new ArrayList<StatementInfo>();
        for (Statement statement : statements) {
            Subject subject = statement.getSubject();
            NodeInfoImpl subjectInfo = new NodeInfoImpl((Node)subject, this.getDocumentModel((Node)subject), true);
            Resource predicate = statement.getPredicate();
            Node object = statement.getObject();
            NodeInfoImpl objectInfo = new NodeInfoImpl(object, this.getDocumentModel(object), true);
            StatementInfoImpl info = new StatementInfoImpl(statement, (NodeInfo)subjectInfo, (NodeInfo)new NodeInfoImpl((Node)predicate), (NodeInfo)objectInfo);
            infoList.add((StatementInfo)info);
        }
        return infoList;
    }

    private DocumentModel getDocumentModel(Node node) {
        if (node.isQNameResource()) {
            QNameResource resource = (QNameResource)node;
            CoreSession session = WebEngine.getActiveContext().getCoreSession();
            Map<String, CoreSession> context = Collections.singletonMap("CoreSession", session);
            Serializable o = ((RelationManager)Framework.getLocalService(RelationManager.class)).getResourceRepresentation(resource.getNamespace(), (Resource)resource, context);
            if (o instanceof DocumentModel) {
                return (DocumentModel)o;
            }
        }
        return null;
    }

    private String getPredicateLabel(String directoryName, StatementInfo statementInfo) {
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        Session session = directoryService.open(directoryName);
        DocumentModel entry = session.getEntry(statementInfo.getPredicate().getUri());
        return (String)((Object)entry.getPropertyValue("vocabulary:label"));
    }
}

