/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.web.ui.url.codec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;

public class WebNotificationDocumentIdCodec
extends AbstractDocumentViewCodec {
    protected static final List<String> WEB_UI_URL_PREFIXES = Arrays.asList("ui", "#!");

    public String getUrlFromDocumentView(DocumentView docView) {
        DocumentLocation docLoc = docView.getDocumentLocation();
        if (docLoc == null) {
            return null;
        }
        IdRef docRef = docLoc.getIdRef();
        if (docRef == null) {
            return null;
        }
        ArrayList<String> fragments = new ArrayList<String>();
        fragments.addAll(WEB_UI_URL_PREFIXES);
        fragments.add(this.getPrefix());
        fragments.add(docLoc.getServerName());
        fragments.add(docRef.toString());
        return StringUtils.join(fragments, (String)"/");
    }

    public DocumentView getDocumentViewFromUrl(String url) {
        int prefixCount;
        String[] fragments;
        String path = url;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((fragments = path.split("/")).length < (prefixCount = WEB_UI_URL_PREFIXES.size()) + 3 || !this.getPrefix().equals(fragments[prefixCount])) {
            return null;
        }
        return new DocumentViewImpl((DocumentLocation)new DocumentLocationImpl(fragments[prefixCount + 1], (DocumentRef)new IdRef(fragments[prefixCount + 2])));
    }
}

