/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webpage.archiver;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineExecutorComponent;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.webpage.archiver.CommandLineParameters;

public class WebpageToBlob {
    private static final Log log = LogFactory.getLog(WebpageToBlob.class);
    public static final String COMMANDLINE_DEFAULT_wkhtmltopdf = "wkhtmlToPdf";
    public static final String COMMANDLINE_DEFAULT_wkhtmltopdf_AUTHENTICATED = "wkhtmlToPdf-authenticated";
    public static final int TIMEOUT_DEFAULT = 30000;
    protected int timeout = 30000;

    public WebpageToBlob() {
        this(0);
    }

    public WebpageToBlob(int inTimeout) {
        this.setTimeout(inTimeout);
    }

    public static boolean isAvailable() {
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        CommandAvailability ca = cles.getCommandAvailability(COMMANDLINE_DEFAULT_wkhtmltopdf);
        return ca.isAvailable();
    }

    public Blob toPdf(String inCommandLine, String inUrl, String inFileName) throws IOException, CommandNotAvailable, NuxeoException {
        return this.run(inCommandLine, inUrl, inFileName, null);
    }

    public Blob toPdf(String inCommandLine, String inUrl, String inFileName, Blob inCookieJar) throws IOException, CommandNotAvailable, NuxeoException {
        return this.run(inCommandLine, inUrl, inFileName, inCookieJar);
    }

    public Blob login(String inCommandLine) throws IOException, NuxeoException, CommandNotAvailable {
        if (StringUtils.isBlank((String)inCommandLine)) {
            throw new NuxeoException("When calling login(), a valid commandline must be passed, the default one does not handle authentification");
        }
        Blob cookieJar = Blobs.createBlobWithExtension((String)".jar");
        Blob ignorePdf = this.run(inCommandLine, cookieJar);
        return cookieJar;
    }

    public Blob login(String inCommandLine, Properties inTestProps) throws IOException, NuxeoException, CommandNotAvailable {
        if (!Framework.isTestModeSet()) {
            throw new NuxeoException("A call to login(String inCommandLine, Properties inTestProps) can me made only in test mode.");
        }
        if (StringUtils.isBlank((String)inCommandLine)) {
            throw new NuxeoException("When calling login(), a valid commandline must be passed, the default one does not handle authentification");
        }
        CmdParameters params = new CmdParameters();
        String loginUrl = inTestProps.getProperty("loginUrl");
        params.addNamedParameter("url", loginUrl);
        Blob cookieJar = Blobs.createBlobWithExtension((String)".jar");
        params.addNamedParameter("cookieJar", cookieJar.getFile().getAbsolutePath());
        params.addNamedParameter("loginVar", inTestProps.getProperty("loginVar"));
        params.addNamedParameter("loginValue", inTestProps.getProperty("loginValue"));
        params.addNamedParameter("pwdVar", inTestProps.getProperty("pwdVar"));
        params.addNamedParameter("pwdValue", inTestProps.getProperty("pwdValue"));
        params.addNamedParameter("submitVar", inTestProps.getProperty("submitVar"));
        params.addNamedParameter("submitValue", inTestProps.getProperty("submitValue"));
        Blob ignorePdf = this.buildCommandLineAndRun(inCommandLine, params, null, true);
        return cookieJar;
    }

    protected Blob run(String inCommandLine, Blob inCookieJar) throws NuxeoException, IOException, CommandNotAvailable {
        return this.run(inCommandLine, null, null, inCookieJar);
    }

    protected Blob run(String inCommandLine, String inUrl, String inFileName, Blob inCookieJar) throws IOException, CommandNotAvailable, NuxeoException {
        if (StringUtils.isBlank((String)inCommandLine)) {
            inCommandLine = COMMANDLINE_DEFAULT_wkhtmltopdf;
        }
        CmdParameters params = new CmdParameters();
        if (inCookieJar != null) {
            params.addNamedParameter("cookieJar", inCookieJar.getFile().getAbsolutePath());
        }
        if (StringUtils.isNotBlank((String)inUrl)) {
            params.addNamedParameter("url", inUrl);
        }
        return this.buildCommandLineAndRun(inCommandLine, params, inFileName, false);
    }

    protected Blob buildCommandLineAndRun(String inCommandLine, CmdParameters inParams, String inFileName, boolean inUseAllParams) throws IOException, CommandNotAvailable, NuxeoException {
        Blob resultPdf = Blobs.createBlobWithExtension((String)".pdf");
        String resolvedParameterString = CommandLineParameters.buildParameterString(inCommandLine, inParams.getParameter("cookieJar"), inParams.getParameter("url"), resultPdf.getFile().getAbsolutePath());
        if (inUseAllParams) {
            if (!Framework.isTestModeSet()) {
                throw new NuxeoException("A call to buildCommandLineAndRun(..., true) is for test only.");
            }
            Map allParams = inParams.getParameters();
            for (Map.Entry entry : allParams.entrySet()) {
                String key = (String)entry.getKey();
                String value = ((CmdParameters.ParameterValue)entry.getValue()).getValue();
                if (CommandLineParameters.isHandledParameter(key)) continue;
                resolvedParameterString = StringUtils.replace((String)resolvedParameterString, (String)("#{" + key + "}"), (String)value);
            }
        }
        CommandLineDescriptor desc = CommandLineExecutorComponent.getCommandDescriptor((String)inCommandLine);
        String line = desc.getCommand() + " " + resolvedParameterString;
        IOException exception = null;
        CommandLine cmdLine = CommandLine.parse((String)line);
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog((long)this.timeout);
        executor.setExitValues(null);
        executor.setWatchdog(watchdog);
        int exitValue = 0;
        try {
            exitValue = executor.execute(cmdLine);
        }
        catch (IOException e) {
            exception = e;
        }
        if (!this.pdfLooksValid(resultPdf.getFile())) {
            resultPdf = null;
            String msg = "Failed to execute the command line [" + cmdLine.toString() + " ]. No valid PDF generated. exitValue: " + exitValue;
            if (exitValue == 143) {
                msg = msg + " (time out reached. The timeout was " + this.timeout + "ms)";
            }
            if (exception == null) {
                throw new NuxeoException(msg);
            }
            throw new NuxeoException(msg, (Throwable)exception);
        }
        resultPdf.setMimeType("application/pdf");
        String url = inParams.getParameter("url");
        if (StringUtils.isBlank((String)inFileName) && StringUtils.isNotBlank((String)url)) {
            URL urlObj = new URL(url);
            inFileName = StringUtils.replace((String)urlObj.getHost(), (String)".", (String)"-") + ".pdf";
        }
        if (StringUtils.isNotBlank((String)inFileName)) {
            resultPdf.setFilename(inFileName);
        }
        return resultPdf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pdfLooksValid(File inPdf) {
        boolean valid = false;
        if (inPdf.exists() && inPdf.length() > 0L) {
            PDDocument pdfDoc = null;
            try {
                pdfDoc = PDDocument.load((File)inPdf);
                if (pdfDoc.getNumberOfPages() > 0) {
                    valid = true;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (pdfDoc != null) {
                    try {
                        pdfDoc.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return valid;
    }

    public void setTimeout(int newValue) {
        this.timeout = newValue < 1 ? 30000 : newValue;
    }
}

